% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{removeunconnected}
\alias{removeunconnected}
\title{Remove Unconnected Segments}
\usage{
removeunconnected(rivers)
}
\arguments{
\item{rivers}{The river network object to use.}
}
\description{
Detects and removes segments that are not connected to the river mouth.
}
\note{
This function is called within \link{cleanup}, which is recommended in most cases.
}
\examples{
data(Koyukuk2)
Koy_subset <- trimriver(trimto=c(30,28,29,3,19,27,4),rivers=Koyukuk2)
Koy_subset <- setmouth(seg=1,vert=427,rivers=Koy_subset)
plot(Koy_subset)

Koy_subset_trim <- removeunconnected(Koy_subset)
plot(Koy_subset_trim)
}
\author{
Matt Tyers
}
