% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{highlightseg}
\alias{highlightseg}
\title{Highlight Segments}
\usage{
highlightseg(seg, rivers, cex = 0.8, lwd = 3, add = FALSE, color = FALSE, ...)
}
\arguments{
\item{seg}{A vector of segments to highlight}

\item{rivers}{The river network object to use}

\item{cex}{The character expansion factor to use for segment labels}

\item{lwd}{The line width to use for highlighted segments}

\item{add}{Whether to add the highlighted segments to an existing plot (\code{TRUE}) or call a new plot (\code{FALSE}).  Defaults to \code{FALSE}.}

\item{color}{Whether to display segment labels as the same color as the segments.  Defaults to \code{FALSE}.}

\item{...}{Additional plotting arguments (see \link[graphics]{par})}
}
\description{
Plots a river network object and displays specified segments in bold, for easy identification.
}
\examples{
data(Kenai3)
plot(Kenai3)
highlightseg(seg=c(10,30,68),rivers=Kenai3)
}
\author{
Matt Tyers
}
