% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsn2lsid.R
\name{tsn2lsid}
\alias{tsn2lsid}
\title{Gets the unique LSID for the TSN, or an empty result if there is no match.}
\usage{
tsn2lsid(tsn, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
a character string, an LSID, or \code{NULL} if nothing found
}
\description{
Gets the unique LSID for the TSN, or an empty result if there is no match.
}
\examples{
\dontrun{
tsn2lsid(tsn = 155166)
tsn2lsid(tsn = 333333333)
tsn2lsid(155166, raw = TRUE)
tsn2lsid(155166, wt = "xml")
}
}
