% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq_num.R
\docType{data}
\name{freq}
\alias{freq}
\title{List current frequency information.}
\format{
An object of class \code{list} of length 11.
}
\usage{
freq
}
\description{
\code{freq} is a list of named numeric variables
containing 11 key frequencies (and their values):
}
\details{
\enumerate{

 \item the population size \code{\link{N}}

 \item the number of cases for which \code{\link{cond_true}}
 \item the number of cases for which \code{\link{cond_false}}

 \item the number of cases for which \code{\link{dec_pos}}
 \item the number of cases for which \code{\link{dec_neg}}

 \item the number of cases for which \code{\link{dec_cor}}
 \item the number of cases for which \code{\link{dec_err}}

 \item the number of true positives, or hits \code{\link{hi}}
 \item the number of false negatives, or misses \code{\link{mi}}
 \item the number of false positives, or false alarms \code{\link{fa}}
 \item the number of true negatives, or correct rejections \code{\link{cr}}

}

These frequencies are computed from basic parameters
(contained in \code{\link{num}}) and computed by using
\code{\link{comp_freq}}.

The list \code{freq} is the frequency counterpart
to the list containing probability information \code{\link{prob}}.

Natural frequencies are always expressed in
relation to the current population of
size \code{\link{N}}.

Key relationships between frequencies and probabilities
(see documentation of \code{\link{comp_freq}} or \code{\link{comp_prob}} for details):

\itemize{

  \item Three perspectives on a population:

  by condition / by decision / by accuracy.

  \item Defining probabilities in terms of frequencies:

  Probabilities can be computed as ratios between frequencies, but beware of rounding issues.

}

Functions translating between representational formats:
\code{\link{comp_prob_prob}}, \code{\link{comp_prob_freq}},
\code{\link{comp_freq_prob}}, \code{\link{comp_freq_freq}}
(see documentation of \code{\link{comp_prob_prob}} for details).

Visualizations of current frequency information
are provided by \code{\link{plot_prism}} and
\code{\link{plot_icons}}.
}
\examples{
freq <- comp_freq()  # initialize freq to default parameters
freq                 # show current values
length(freq)         # 11 known frequencies
names(freq)          # show names of known frequencies

}
\seealso{
\code{\link{comp_freq}} computes current frequency information;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{prob}} contains current probability information;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{txt}} contains current text information;
\code{\link{init_txt}} initializes text information;
\code{\link{pal}} contains current color information;
\code{\link{init_pal}} initializes color information.

Other lists containing current scenario information: 
\code{\link{accu}},
\code{\link{num}},
\code{\link{pal_bwp}},
\code{\link{pal_bw}},
\code{\link{pal_kn}},
\code{\link{pal_mbw}},
\code{\link{pal_mod}},
\code{\link{pal_org}},
\code{\link{pal_rgb}},
\code{\link{pal_unikn}},
\code{\link{pal_vir}},
\code{\link{pal}},
\code{\link{prob}},
\code{\link{txt_TF}},
\code{\link{txt_org}},
\code{\link{txt}}
}
\concept{lists containing current scenario information}
\keyword{datasets}
