% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_curve.R
\name{plot_curve}
\alias{plot_curve}
\title{Plot curves of selected values (e.g., PPV or NPV)
as a function of prevalence.}
\usage{
plot_curve(prev = num$prev, sens = num$sens, mirt = NA, spec = num$spec,
  fart = NA, what = c("prev", "PPV", "NPV"), what.col = pal,
  show.points = TRUE, log.scale = FALSE, title.lbl = txt$scen.lbl,
  cex.lbl = 0.85)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{mirt} is provided.}

\item{mirt}{The decision's miss rate \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{sens} is provided.}

\item{spec}{The decision's specificity \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{fart} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{spec} is provided.}

\item{what}{A vector of character codes that specify the
selection of curves to be plotted. Currently available
options are \code{c("prev", "PPV", "NPV", "ppod", "acc")}
(shortcut: \code{what = "all"}).
Default: \code{what = c("prev", "PPV", "NPV")}.}

\item{what.col}{A vector of colors corresponding to the elements
specified in \code{what}.
Default: \code{what.col = pal}.}

\item{show.points}{Boolean option for showing the point of
intersection with the current prevalence \code{\link{prev}}
in all selected curves.
Default: \code{show.points = TRUE}.}

\item{log.scale}{Boolean value for switching from a linear
to a logarithmic x-axis.
Default: \code{log.scale = FALSE}.}

\item{title.lbl}{The title of the current plot.
Default: \code{title.lbl = txt$scen.lbl}.}

\item{cex.lbl}{Scaling factor for the size of text labels
(e.g., on axes, legend, margin text).
Default: \code{cex.lbl = .85}.}
}
\description{
\code{plot_curve} draws curves of selected values
(including \code{\link{PPV}}, \code{\link{NPV}})
as a function of the prevalence (\code{\link{prev}})
for given values of
sensitivity \code{\link{sens}} (or
miss rate \code{\link{mirt}}) and
specificity \code{\link{spec}} (or
false alarm rate \code{\link{fart}}).
}
\details{
\code{plot_curve} is a generalization of
\code{plot_PV} (see legacy code)
that allows for additional dependent values.
}
\examples{
# Basics:
plot_curve()                     # => default: what = ("prev", "PPV", "NPV")
plot_curve(show.points = FALSE)  # => default without points

# all curves:
plot_curve(what = "all") # => all curves: what = ("prev", "PPV", "NPV", "ppod", "acc")
plot_curve(what = "all", show.points = FALSE)  # => all curves, no points

# selected curves:
plot_curve(what = c("PPV", "NPV"))                  # => PPV and NPV
plot_curve(what = c("prev", "PPV", "NPV", "acc"))   # => prev, PPV, NPV, and acc
plot_curve(what = c("prev", "PPV", "NPV", "ppod"))  # => prev, PPV, NPV, and acc

# X-axis as linear vs. log scale:
plot_curve(prev = .01, sens = .9, spec = .8)                     # => linear scale
plot_curve(prev = .01, sens = .9, spec = .8, log.scale = TRUE)   # => log scale

plot_curve(prev = .0001, sens = .7, spec = .6)                   # => linear scale
plot_curve(prev = .0001, sens = .7, spec = .6, log.scale = TRUE) # => log scale

# Other options:
plot_curve(title.lbl = "Testing smaller text labels", cex.lbl = .60)
plot_curve(what = "all", what.col = c("grey", "red3", "green3", "blue3", "gold"))


}
\seealso{
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{freq}} contains current frequency information;
\code{\link{num}} for basic numeric parameters;
\code{\link{txt}} for current text settings;
\code{\link{pal}} for current color settings.

Other visualization functions: \code{\link{plot.riskyr}},
  \code{\link{plot_fnet}}, \code{\link{plot_icons}},
  \code{\link{plot_mosaic}}, \code{\link{plot_plane}},
  \code{\link{plot_tree}}
}
