% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riskRegression-package.R
\docType{data}
\name{Paquid}
\alias{Paquid}
\title{Paquid sample}
\format{
A data frame with 2561 observations on the following 4 variables.
\describe{
\item{\code{time}}{the time-to-event (in years).}
\item{\code{status}}{the type of event \code{0} = censored, \code{1} = dementia onset and \code{2} = death without dementia.}
\item{\code{DSST}}{score at the Digit Symbol Substitution Score Test. This test explores attention and psychomotor speed.}
\item{\code{MMSE}}{score at the Mini Mental State Examination. This test is often used as an index of global cognitive performance.}
}
}
\source{
The data have been first made publicly available via the package timeROC.
}
\description{
PAQUID is a prospective cohort study initiated in 1988 in South Western
France to explore functional and cerebral ageing. This sample includes
n=2561 subjects. Data contains a time-to-event, a type of event and 
two cognitive scores measured at baseline.
}
\examples{
data(Paquid)
}
\references{
Dartigues, J., Gagnon, M., Barberger-Gateau, P., Letenneur, L., Commenges, D.,
Sauvel, C., Michel, P., and Salamon, R. (1992). The paquid epidemiological program
on brain ageing. Neuroepidemiology, 11(1):14--18.


Blanche, P., Dartigues, J. F., & Jacqmin-Gadda, H. (2013). Estimating and
comparing time-dependent areas under receiver operating characteristic curves
for censored event times with competing risks. Statistics in Medicine, 32(30),
5381-5397.
}
\keyword{datasets}
