% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCalibration.R
\name{plotCalibration}
\alias{plotCalibration}
\title{Plot Calibration curve}
\usage{
plotCalibration(
  x,
  models,
  times,
  method = "nne",
  cens.method,
  round = TRUE,
  bandwidth = NULL,
  q = 10,
  bars = FALSE,
  hanging = FALSE,
  names = "quantiles",
  pseudo = FALSE,
  rug,
  show.frequencies = FALSE,
  plot = TRUE,
  add = FALSE,
  diag = !add,
  legend = !add,
  auc.in.legend,
  brier.in.legend,
  axes = !add,
  xlim = c(0, 1),
  ylim = c(0, 1),
  xlab = ifelse(bars, "Risk groups", "Predicted risk"),
  ylab = "Observed frequency",
  col,
  lwd,
  lty,
  pch,
  type,
  percent = TRUE,
  na.action = na.fail,
  cex = 1,
  ...
)
}
\arguments{
\item{x}{Object obtained with function \code{Score}}

\item{models}{Choice of models to plot}

\item{times}{Time point specifying the prediction horizon.}

\item{method}{The method for estimating the calibration curve(s):
\itemize{
\item{\code{"quantile"}}{The observed proportion at predicted risk value 'p'
is obtained in groups
defined by quantiles of the predicted event probabilities of all subjects.
The number of groups is controlled by argument \code{q}.}
\item{\code{"nne"}}: {The observed proportion at predicted risk value 'p' is obtained based
on the subjects whose predicted risk is inside a nearest
neighborhood around the value 'p'. The larger the
bandwidth the more subjects are included in the current neighborhood. 
}}}

\item{cens.method}{For right censored data only. How observed proportions are calculated. Either \code{"jackknife"} or \code{"local"}:
\itemize{
\item{\code{"jackknife"}}{Compute a running mean of the jackknife pseudovalues across neighborhoods/groups of the predicted risks.
Here we rely on the
assumption that censoring is independent of the event time and the covariates, see References. }
\item{\code{"local"}}{Compute the Kaplan-Meier estimator in absence of competing risks and the Aalen-Johansen estimator in presence of competing risks
locally like a running mean in neighborhoods of the predicted risks. The widths of the neighborhoods
are defined according to method.
}}}

\item{round}{If \code{TRUE} predicted probabilities are rounded to
two digits before smoothing. This may have a considerable
effect on computing efficiency in large data sets.}

\item{bandwidth}{The bandwidth for \code{method="nne"}}

\item{q}{The number of quantiles for \code{method="quantile"} and
\code{bars=TRUE}.}

\item{bars}{If \code{TRUE}, use barplots to show calibration.}

\item{hanging}{Barplots only. If \code{TRUE}, hang bars
corresponding to observed frequencies at the value of the
corresponding prediction.}

\item{names}{Barplots only. Names argument passed to
\code{names.arg} of \code{barplot}.}

\item{pseudo}{If \code{TRUE} show pseudo values (only for right
censored data).}

\item{rug}{If \code{TRUE} show rug plot at the predictions}

\item{show.frequencies}{Barplots only. If \code{TRUE}, show
frequencies above the bars.}

\item{plot}{If \code{FALSE}, do not plot the results, just return
a plottable object.}

\item{add}{If \code{TRUE} the line(s) are added to an existing
plot.}

\item{diag}{If \code{FALSE} no diagonal line is drawn.}

\item{legend}{Logical. If \code{TRUE} draw legend.}

\item{auc.in.legend}{Logical. If \code{TRUE} add AUC to legend.}

\item{brier.in.legend}{Logical. If \code{TRUE} add Brier score to
legend.}

\item{axes}{If \code{FALSE} no axes are drawn.}

\item{xlim}{Limits of x-axis.}

\item{ylim}{Limits of y-axis.}

\item{xlab}{Label for y-axis.}

\item{ylab}{Label for x-axis.}

\item{col}{Vector with colors, one for each element of
object. Passed to \code{\link{lines}}.}

\item{lwd}{Vector with line widths, one for each element of
object. Passed to \code{\link{lines}}.}

\item{lty}{lwd Vector with line style, one for each element of
object.  Passed to \code{\link{lines}}.}

\item{pch}{Passed to \code{\link{lines}}.}

\item{type}{Passed to \code{\link{lines}}.}

\item{percent}{If TRUE axes labels are multiplied by 100 and thus
interpretable on a percent scale.}

\item{na.action}{what to do with NA values. Passed to
\code{\link{model.frame}}}

\item{cex}{Default cex used for legend and labels.}

\item{...}{Used to control the subroutines: plot, axis, lines,
barplot, legend, addtable2plot, points (pseudo values), rug. See
\code{\link{SmartControl}}.}
}
\description{
Plot Calibration curve
}
\examples{
library(prodlim)
# binary 
db=sampleData(100,outcome="binary")
fb1=glm(Y~X1+X5+X7,data=db,family="binomial")
fb2=glm(Y~X1+X3+X6+X7,data=db,family="binomial")
xb=Score(list(model1=fb1,model2=fb2),Y~1,data=db,
          plots="cal")
plotCalibration(xb,brier.in.legend=TRUE)
plotCalibration(xb,bars=TRUE,model="model1")
plotCalibration(xb,models=1,bars=TRUE,names.cex=1.3)

# survival
library(survival)
library(prodlim)
dslearn=sampleData(56,outcome="survival")
dstest=sampleData(100,outcome="survival")
fs1=coxph(Surv(time,event)~X1+X5+X7,data=dslearn,x=1)
fs2=coxph(Surv(time,event)~strata(X1)+X3+X6+X7,data=dslearn,x=1)
xs=Score(list(Cox1=fs1,Cox2=fs2),Surv(time,event)~1,data=dstest,
          plots="cal",metrics=NULL)
plotCalibration(xs)
plotCalibration(xs,cens.method="local",pseudo=1)
plotCalibration(xs,method="quantile")


# competing risks

\dontrun{
data(Melanoma)
f1 <- CSC(Hist(time,status)~age+sex+epicel+ulcer,data=Melanoma)
f2 <- CSC(Hist(time,status)~age+sex+logthick+epicel+ulcer,data=Melanoma)
x <- Score(list(model1=f1,model2=f2),Hist(time,status)~1,data=Melanoma,
           cause= 2,times=5*365.25,plots="cal")
plotCalibration(x)
}

}
