% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxBaseEstimator}
\alias{CoxBaseEstimator}
\alias{CoxBaseEstimator.coxph}
\alias{CoxBaseEstimator.phreg}
\title{Extract the type of estimator for the baseline hazard}
\usage{
CoxBaseEstimator(object)

\method{CoxBaseEstimator}{coxph}(object)

\method{CoxBaseEstimator}{phreg}(object)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package), \code{cph}
(rms package), or \code{phreg} (mets package).}
}
\description{
Extract the type of estimator for the baseline hazard
}
\examples{
\dontrun{
d <- sampleData(1e2, outcome = "survival")
d$entry <- 0

##
library(survival)
mCox <- coxph(Surv(time, event) ~ X1+X2, data = d)
CoxBaseEstimator(mCox)

##
library(rms)
mCox <- cph(Surv(time, event) ~ X1+X2, data = d, y = TRUE)
CoxBaseEstimator(mCox)

##
library(mets)
mCox <- phreg(Surv(entry, time, event) ~ X1+X2, data = d)
CoxBaseEstimator(mCox)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}

