% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ate.R
\name{ate}
\alias{ate}
\title{Compute the average treatment effect using CSC.}
\usage{
ate(object, data, treatment, contrasts = NULL, times, cause,
  conf.level = 0.95, B = 0, seed, handler = c("mclapply", "foreach"),
  mc.cores = 1, verbose = TRUE, ...)
}
\arguments{
\item{object}{outcome model which describes how event risk depends on treatment and covariates.
The object carry its own call and have a \code{predictRisk} method. See examples.}

\item{data}{data set in which to evaluate risk predictions based on the outcome model}

\item{treatment}{name of the treatment variable}

\item{contrasts}{the levels of treatment variable to be compared}

\item{times}{time points at which to evaluate risks}

\item{cause}{the cause of interest}

\item{conf.level}{Numeric. Confidence level of the confidence intervals. Disregarded if negative.}

\item{B}{the number of bootstrap replications used to compute the
confidence intervals. If it equals 0, then Wald-type confidence intervals are computed.
They rely on the standard error estimated using the influence function of the estimator.}

\item{seed}{An integer used to generate seeds for bootstrap and to
achieve reproducibility of the bootstrap confidence intervals.}

\item{handler}{parallel handler for bootstrap. Either "mclapply" or
"foreach". If "foreach" use \code{doParallel} to create a cluster.}

\item{mc.cores}{Passed to \code{parallel::mclapply} or
\code{doParallel::registerDoParallel}. The number of cores to use, i.e. at
most how many child processes will be run simultaneously.  The
option is initialized from environment variable MC_CORES if
set.}

\item{verbose}{Logical. If \code{TRUE} inform about estimated run
time.}

\item{...}{passed to predictRisk}
}
\value{
A list with: point estimates, bootstrap quantile confidence
    intervals model: the CSC model (optional)
}
\description{
Use the g-formula to estimate the average treatment effect
}
\examples{
library(survival)
library(rms)

set.seed(10)
n <- 1e2

## Cox model
dtS <- sampleData(n,outcome="survival")
dtS$time <- round(dtS$time,1)
dtS$X1 <- factor(rbinom(n, prob = c(0.3,0.4) , size = 2), labels = paste0("T",0:2))

fit=cph(formula = Surv(time,event)~ X1+X2,data=dtS,y=TRUE,x=TRUE)
## the cph object carries its call:
fit$call
## and there is a predictRisk method
"predictRisk.cph" \%in\% methods("predictRisk")

ateFit=ate(fit, data = dtS, treatment = "X1", contrasts = NULL,
        times = 5:7, B = 3, y = TRUE, mc.cores=1)

ateFit=ate(fit, data = dtS, treatment = "X1", contrasts = NULL,
        times = 5:7, B = 0, y = TRUE, mc.cores=1)

## Cause specific cox model
set.seed(17)
n=200
dt <- sampleData(n,outcome="competing.risks")
dt$time <- round(dt$time,1)
dt$X1 <- factor(rbinom(n, prob = c(0.2,0.3,0.2) , size = 3), labels = paste0("T",0:3))
fitCR= CSC(Hist(time,event)~ X1+X8,data=dt,cause=1)
ate(fitCR, data = dt, treatment = "X1", contrasts = NULL,
        times = 7, cause = 1, B = 2, mc.cores=1)

atefit=ate(fitCR, data = dt, treatment = "X1", contrasts = NULL,
        times = 1:7, cause = 1, B = 0, mc.cores=1,conf.level=FALSE)

\dontrun{
 ate(fitCR, data = dt, treatment = "X1", contrasts = NULL,
        times = 5:7, cause = 1, B = 0, mc.cores=1)
}

}

