% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointEstimate.R
\name{pointEstimate}
\alias{pointEstimate}
\title{Perform g-computation to estimate difference and ratio effects of an exposure}
\usage{
pointEstimate(
  data,
  outcome.type = c("binary", "count", "rate", "continuous"),
  formula = NULL,
  Y = NULL,
  X = NULL,
  Z = NULL,
  subgroup = NULL,
  offset = NULL,
  rate.multiplier = 1,
  exposure.scalar = 1,
  exposure.center = TRUE
)
}
\arguments{
\item{data}{(Required) A data.frame containing variables for
\code{Y}, \code{X}, and \code{Z} or with variables matching the model
variables specified in a user-supplied formula. Data set should also
contain variables for the optional \code{subgroup} and \code{offset}, if
they are specified.}

\item{outcome.type}{(Required) Character argument to describe the outcome
type. Acceptable responses, and the corresponding error distribution and
link function used in the \code{glm}, include: \describe{
\item{binary}{(Default) A binomial distribution with link = 'logit' is
used.} \item{count}{A Poisson distribution 
with link = 'log' is used.}
\item{rate}{A Poisson distribution with link = 'log' is used; ideal for 
 events/person-time outcomes.} \item{continuous}{A gaussian distribution 
 with link = 'identity' is used.}
}}

\item{formula}{(Optional) Default NULL. An object of class "formula" (or one
that can be coerced to that class) which provides the the complete model
formula, similar to the formula for the glm function in R (e.g. `Y ~ X + Z1
+ Z2 + Z3`). Can be supplied as a character or formula object. If no
formula is provided, Y and X must be provided.}

\item{Y}{(Optional) Default NULL. Character argument which specifies the
outcome variable. Can optionally provide a formula instead of \code{Y} and
\code{X} variables.}

\item{X}{(Optional) Default NULL. Character argument which specifies the
exposure variable (or treatment group assignment), which can be binary,
categorical, or continuous. This variable can be supplied as a factor
variable (for binary or categorical exposures) or a continuous variable.
For binary/categorical exposures, \code{X} should be supplied as a factor with 
the lowest level set to the desired referent. Numeric variables are 
accepted, but will be centered (see Note). Character variables are not 
accepted and will throw an error. Can optionally provide a formula
instead of \code{Y} and \code{X} variables.}

\item{Z}{(Optional) Default NULL. List or single character vector which
specifies the names of covariates or other variables to adjust for in the
\code{glm} function. All variables should either be factors, continuous, 
or coded 0/1 (i.e. not character variables). Does not allow interaction terms.}

\item{subgroup}{(Optional) Default NULL. Character argument that indicates
subgroups for stratified analysis. Effects will be reported for each
category of the subgroup variable. Variable will be automatically converted
to a factor if not already.}

\item{offset}{(Optional, only applicable for rate outcomes) Default NULL.
Character argument which specifies the person-time denominator for rate
outcomes to be included as an offset in the Poisson regression model.
Numeric variable should be on the linear scale; function will take natural
log before including in the model.}

\item{rate.multiplier}{(Optional, only applicable for rate outcomes) Default
1. Numeric value to multiply to the rate-based effect measures. This option
facilitates reporting effects with interpretable person-time denominators.
For example, if the person-time variable (offset) is in days, a multiplier
of 365*100 would result in estimates of rate differences per 100
person-years.}

\item{exposure.scalar}{(Optional, only applicable for continuous exposure)
Default 1. Numeric value to scale effects with a continuous exposure. This 
option facilitates reporting effects for an interpretable contrast (i.e. 
magnitude of difference) within the continuous exposure. For example, if 
the continuous exposure is age in years, a multiplier of 10 would result 
in estimates per 10-year increase in age rather than per a 1-year increase 
in age.}

\item{exposure.center}{(Optional, only applicable for continuous exposure)
Default TRUE. Logical or numeric value to center a continuous exposure. This
option facilitates reporting effects at the mean value of the exposure 
variable, and allows for a mean value to be provided directly to the function
in cases where bootstrap resampling is being conducted and a standardized 
centering value should be used across all bootstraps. See note below on 
continuous exposure variables for additional details.}
}
\value{
A named list containing the following: 

  \item{$parameter.estimates}{Point estimates for the risk difference, risk
  ratio, odds ratio, incidence rate difference, incidence rate ratio, mean
  difference and/or number needed to treat/harm, depending on the outcome.type}
  \item{$formula}{Model formula used to fit the \code{glm}}    
  \item{$contrast}{Contrast levels compared} 
  \item{$Y}{The response variable} 
  \item{$covariates}{Covariates used in the model} 
  \item{$n}{Number of observations provided to the model} 
  \item{$family}{Error distribution used in the model} 
  \item{$predicted.data}{A data.frame with the predicted values for the exposed 
  and unexposed counterfactual predictions for each observation in the original 
  dataset (on the log scale)} 
   \item{$predicted.outcome}{A data.frame with the marginal mean
  predicted outcomes for each exposure level} 
  \item{$glm.result}{The \code{glm} class object returned from the 
  fitted regression of the outcome on the exposure and relevant covariates.} 
  formula = formula,
}
\description{
Generate a point estimate of the outcome difference and ratio
  using G-computation
}
\details{
The \code{pointEstimate} function executes the following steps on
  the data: 
  \enumerate{ 
  \item Fit a regression of the outcome on the exposure
  and relevant covariates, using the provided data set. 
  \item Using the
  modelfit in step 1, predict counterfactuals (e.g. calculate predicted
  outcomes for each observation in the data set under each level of the
  treatment/exposure). 
  \item Estimate the marginal difference/ratio of treatment effect by 
  taking the difference or ratio of the average of all observations under 
  the treatment/no treatment regimes. 
  }

  As counterfactual predictions are generated with random sampling of the
  distribution, users should set a seed (\code{\link{set.seed}}) for
  reproducible confidence intervals.
}
\note{
Note that for a protective exposure (risk difference less than 0), the 
  'Number needed to treat/harm' is interpreted as the number needed to treat, 
  and for a harmful exposure (risk difference greater than 0), it is 
  interpreted as the number needed to harm.

For continuous exposure variables, the default effects are provided 
  for a one unit difference in the exposure at the mean value of the exposure 
  variable. Because the underlying parametric model for a binary outcome is 
  logistic regression, the risks for a continuous exposure will be estimated 
  to be linear on the log-odds (logit) scale, such that the odds ratio for 
  any one unit increase in the continuous variable is constant. However, 
  the risks will not be linear on the linear (risk difference) or log (risk 
  ratio) scales, such that these parameters will not be constant across the 
  range of the continuous exposure. Users should be aware that the risk 
  difference, risk ratio, number needed to treat/harm (for a binary outcome) 
  and the incidence rate difference (for a rate/count outcome) reported with 
  a continuous exposure apply specifically at the mean of the continuous 
  exposure. The effects do not necessarily apply across the entire range of 
  the variable. However, variations in the effect are likely small, 
  especially near the mean.
}
\examples{
## Obtain the risk difference and risk ratio for cardiovascular disease or death
## between patients with and without diabetes, while controlling for
## age,
## sex,
## BMI,
## whether the individual is currently a smoker, and
## if they have a history of hypertension.
data(cvdd)
ptEstimate <- pointEstimate(data = cvdd, Y = "cvd_dth", X = "DIABETES",
Z = c("AGE", "SEX", "BMI", "CURSMOKE", "PREVHYP"), outcome.type = "binary")

}
\references{
Ahern J, Hubbard A, Galea S. Estimating the effects of potential public health 
  interventions on population disease burden: a step-by-step illustration of 
  causal inference methods. Am. J. Epidemiol. 2009;169(9):1140–1147.
  \href{https://doi.org/10.1093/aje/kwp015}{Manuscript link}
 
 Altman DG, Deeks JJ, Sackett DL. Odds ratios should be avoided when events 
  are common. BMJ. 1998;317(7168):1318. \href{https://doi.org/10.1136/bmj.317.7168.1318 }{Manuscript link}

 Hernán MA, Robins JM (2020). Causal Inference: What If. Boca Raton: 
  Chapman & Hall/CRC. /href{https://www.hsph.harvard.edu/miguel-hernan/causal-inference-book/}{Book link}

 Robins J. A new approach to causal inference in mortality studies with a 
  sustained exposure period—application to control of the healthy worker 
  survivor effect. Mathematical Modelling. 1986;7(9):1393–1512. \href{https://doi.org/10.1016/0270-0255(86)90088-6}{Manuscript link}
  
 Snowden JM, Rose S, Mortimer KM. Implementation of G-computation on a 
  simulated data set: demonstration of a causal inference technique. 
  Am. J. Epidemiol. 2011;173(7):731–738. \href{https://doi.org/10.1093/aje/kwq472}{Manuscript link}
  
 Westreich D, Cole SR, Young JG, et al. The parametric g-formula to 
  estimate the effect of highly active antiretroviral therapy on incident 
   AIDS or death. Stat Med. 2012;31(18):2000–2009. \href{https://doi.org/10.1002/sim.5316}{Manuscript link}
}
\seealso{
\code{\link{gComp}}
}
