% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_functions.R
\name{predict_rinet}
\alias{predict_rinet}
\title{Predict statistics of the underlying reference distribution from mixture distributions using RINet}
\usage{
predict_rinet(
  data,
  feature_grid_range = c(-4, 4),
  feature_grid_nbins = 100,
  verbose = 0,
  log_scale = TRUE,
  percentiles = c(0.025, 0.975),
  n_bootstrap = 0,
  confidence_level = 0.95
)
}
\arguments{
\item{data}{A numeric vector, matrix, or list. For 1D: vector or matrix with
1 column. For 2D: matrix with 2 columns. Can also be a list of such objects.}

\item{feature_grid_range}{Numeric vector of length 2 specifying the range
for histogram binning. Default is c(-4, 4).}

\item{feature_grid_nbins}{Integer specifying the number of histogram bins.
Default is 100.}

\item{verbose}{Integer controlling verbosity (0 = silent). Default is 0.}

\item{log_scale}{Logical indicating whether to log-transform the data before
prediction. If TRUE (default), returns log-scale statistics and calculates
reference intervals in the original scale. Default is TRUE.}

\item{percentiles}{Numeric vector of length 2 specifying the lower and upper
percentiles for the reference interval. Default is c(0.025, 0.975).}

\item{n_bootstrap}{Integer specifying the number of bootstrap resamples for
confidence intervals. Default is 0 (no bootstrap). When > 0, confidence
intervals are computed for all predicted statistics using batch inference.}

\item{confidence_level}{Numeric specifying the confidence level for bootstrap
intervals. Default is 0.95.}
}
\value{
A list of predictions. Each element contains:
  \item{mean}{Predicted mean(s) (log-scale if log_scale=TRUE)}
  \item{std}{Predicted standard deviation(s) (log-scale if log_scale=TRUE)}
  \item{covariance}{Predicted covariance matrix}
  \item{correlation}{Predicted correlation (NA for 1D)}
  \item{reference_fraction}{Predicted reference component fraction}
  \item{reference_interval}{Reference interval in original scale (if log_scale=TRUE)}
  \item{log_scale}{Logical indicating whether log-scaling was used}
  \item{bootstrap_ci}{List of bootstrap confidence intervals (if n_bootstrap > 0)}
}
\description{
Automatically detects whether input data is 1D or 2D and calls the
appropriate prediction function. This is the main user-facing function.
It estimates the statistics of a "healthy" reference population from a
mixture of healthy and pathological measurements.
}
\examples{
\dontrun{
  # 1D sample (using positive data for log-scale)
  sample_1d <- exp(rnorm(1000, mean = 2, sd = 0.5))
  result <- predict_rinet(sample_1d)

  # 2D sample (using positive data for log-scale)
  sample_2d <- exp(matrix(rnorm(2000, mean = 2, sd = 0.5), ncol = 2))
  result <- predict_rinet(sample_2d)

  # Multiple samples (automatically detected)
  samples <- list(exp(rnorm(1000, mean = 2, sd = 0.5)),
                  exp(rnorm(1000, mean = 2, sd = 0.5)))
  results <- predict_rinet(samples)
}
}
