\name{get_inat_obs}
\alias{get_inat_obs}
\title{Download inaturalist data}
\usage{
  get_inat_obs(query = NULL, taxon = NULL, quality = NULL,
    geo = NULL, year = NULL, month = NULL, day = NULL,
    bounds = NULL, maxresults = 100)
}
\arguments{
  \item{query}{Query string for a general search}

  \item{quality}{the quality grade to be used.  Must be
  either "casual" or "research" If left blank both will be
  returned.}

  \item{taxon}{Filter by iNat taxon name. Note that this
  will also select observations of descendant taxa. Note
  that names are not unique, so if the name matches
  multiple taxa, no observations may be returned.}

  \item{geo}{flag for returning only results that are
  georeferenced, TRUE will exclude non-georeferenced
  results, but they cannot be excluded.}

  \item{year}{return observations only in that year (can
  only be one year, not a range of years)}

  \item{month}{return observations only by month, must be
  numeric, 1...12}

  \item{day}{return observations only on a given day of the
  month, 1...31}

  \item{bounds}{a bounding box of longitude (-180 to 180)
  and latitude (-90 to 90) to search within.  It is a
  vector in the form of southern latitude, western
  longitude, northern latitude, and easter longitude}

  \item{maxresults}{the maximum number of results to
  return}
}
\value{
  a dataframe of the number of observations requestsed
}
\description{
  Primary function to retrieve observations from
  iNaturalist, allows users to search for data, or just
  filter results by a subset of what is offered by the API
}
\note{
  Filtering doesn't always work with the query parameter
  for some reason (a problem on the API end).  If you want
  to filter by time, it's best to use the scientific name
  and put it in the 'taxa' field, and not in the query
  field.  Another issue is that the query parameter will
  search the entire entry, so it is possible to get
  unintended results.  Depending on your use case it may be
  advisable to use the "taxon" field instead of the query
  field.
}
\examples{
\dontrun{
  ### Make a standard query
  get_inat_obs(query="Monarch Butterfly")

  ##Filter by a bounding box of Northern California
  bounds <- c(38.44047,-125,40.86652,-121.837)
  get_inat_obs(query="Mule Deer", bounds=bounds)

  ## Filter with by just taxon, allows higher order filtering,
  ## Here we can search for just stone flies (order plecoptera)
  get_inat_obs(taxon="Plecoptera")

}
}

