% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jaccardIndex.R
\name{overlapCoefficient}
\alias{overlapCoefficient}
\alias{overlapDistance}
\title{Overlap coefficient, also known as Szymkiewicz-Simpson coefficient}
\usage{
overlapCoefficient(x, y, checkUniqueNonNA = FALSE)

overlapDistance(x, y, checkUniqueNonNA = FALSE)
}
\arguments{
\item{x}{A vector}

\item{y}{A vector}

\item{checkUniqueNonNA}{Logical, if \code{TRUE}, \code{x} and \code{y} are
made unique and non-NA}
}
\value{
The overlap coefficient
}
\description{
Overlap coefficient, also known as Szymkiewicz-Simpson coefficient
}
\examples{

myX <- 1:6
myY <- 4:9
overlapCoefficient(myX, myY)

myY2 <- 4:10
overlapCoefficient(myX, myY2)
## compare the result with Jaccard Index
jaccardIndex(myX, myY2)

## overlapDistance
overlapDistance(myX, myY2)

}
\seealso{
\code{\link{jaccardIndex}}

\code{overlapCofficient} calculates the overlap coefficient, and
\code{overlapDistance} is defined by 1-\code{overlapCoefficient}.
}
