% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.R
\name{cutInterval}
\alias{cutInterval}
\title{Cut a vector of numbers into interval factors.}
\usage{
cutInterval(
  x,
  step = 1,
  labelOption = c("cut.default", "left", "right"),
  include.lowest = FALSE,
  right = TRUE,
  dig.lab = 3,
  ordered_result = FALSE,
  ...
)
}
\arguments{
\item{x}{A vector of numbers}

\item{step}{Step size.}

\item{labelOption}{How is the label displayed.See \code{details} section.}

\item{include.lowest}{Logical, passed to \code{cut}}

\item{right}{Logial, passed to \code{cut}}

\item{dig.lab}{See \code{\link{cut}}}

\item{ordered_result}{See \code{\link{cut}}}

\item{\dots}{Other parameters that are passed to \code{\link{cut}}}
}
\value{
A vector of factors
}
\description{
Three types of labels (levels) are supported: \dQuote{cut.default} (Interval
labels returned by \code{cut} as default), \dQuote{left} (Left boundary of
intervals), and \dQuote{right} (Right boundary of intervals).
}
\examples{

testNum <- rnorm(100)
(testFac <- cutInterval(testNum, step=1, labelOption="cut.default"))

## compare the result to
(testFacCut <- cut(testNum, 10))

}
\seealso{
\code{\link{cut}}
}
\author{
Jitao David Zhang <jitao_david.zhang@roche.com>
}
