% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_sim.R
\name{dat_sim}
\alias{dat_sim}
\title{Simulate data with multiple treatments and clustered survival outcomes}
\usage{
dat_sim(
  nK,
  K,
  n_trt,
  X,
  lp_y,
  nlp_y,
  align = TRUE,
  eta,
  lambda,
  delta,
  psi,
  lp_w,
  nlp_w,
  sigma_w,
  sigma_y,
  censor_rate
)
}
\arguments{
\item{nK}{A numeric value indicating the number of clusters.}

\item{K}{A numeric value indicating the sample size in each cluster.}

\item{n_trt}{A numeric value indicating the number of treatments.}

\item{X}{A vector of characters representing covariates, with each covariate being generated from the standard probability \code{\link[stats:Distributions]{distributions}} in the \code{\link[stats:stats-package]{stats}} package.}

\item{lp_y}{A vector of characters of length \code{n_trt}, representing the linear effects in the outcome generating model.}

\item{nlp_y}{A vector of characters of length \code{n_trt}, representing the nonlinear effects in the outcome generating model.}

\item{align}{A logical indicating whether the predictors in the treatment assignment model are the same as the predictors for the outcome generating model. The default is \code{TRUE}. If the argument is set to \code{FALSE}, users need to specify additional two arguments \code{lp_w} and \code{nlp_w}.}

\item{eta}{A numeric value to induce proportional hazards assumption or a character including linear combination of Xs to induce nonproportional hazards assumption.}

\item{lambda}{A numeric vector of length \code{n_trt} inducing different follow up time across treatment groups.}

\item{delta}{A numeric vector of length \code{n_trt}-1 inducing different ratio of units across treatment groups.}

\item{psi}{A numeric value for the parameter governing the sparsity of covariate overlap.}

\item{lp_w}{A vector of characters of length \code{n_trt} - 1, representing the treatment assignment model.}

\item{nlp_w}{A vector of characters of length \code{n_trt} - 1, representing the treatment assignment model.}

\item{sigma_w}{A numeric value representing the standard deviation for the cluster effect in the treatment assignment model.}

\item{sigma_y}{A numeric value representing the standard deviation for the cluster effect in the outcome generating model.}

\item{censor_rate}{A numeric value for the rate parameter governing the proportion of censoring.}
}
\value{
A list with 7 elements for simulated data. It contains
\item{covariates:}{X matrix}
\item{w:}{treatment indicators}
\item{Tobs:}{observed follow up time for the simulated right censored data}
\item{status:}{the censoring indicator}
\item{cluster:}{the clustering indicator}
\item{censor_prop:}{the censoring proportion}
\item{T_mean:}{Mean observed follow up time}
\item{ratio_of_units:}{the proportions of units in each treatment group}
}
\description{
This function simulate data with multiple treatments and clustered survival outcomes. Users can adjust the following 11 design factors: (1) The number of clusters, (2) the sample size in each cluster, (3) ratio of units across treatment groups, (4) whether the treatment assignment model and the outcome generating model are linear or nonlinear, (5) whether the covariates that best predict the treatment also predict the outcome well, (6) whether the response surfaces are parallel across treatment groups, (7) degree of covariate overlap, (8) Whether the proportional hazards assumption is satisfied, (9) mean follow up time for each treatment group, (10) censoring proportion and (11) Standard deviation for the cluster effect in the treatment assignment and outcome generating model.
}
\examples{
library(riAFTBART)
lp_w_all <-
  c(".4*x1 + .1*x2  - .1*x4 + .1*x5",    # w = 1
    ".2 * x1 + .2 * x2  - .2 * x4 - .3 * x5")  # w = 2
nlp_w_all <-
  c("-.5*x1*x4  - .1*x2*x5", # w = 1
    "-.3*x1*x4 + .2*x2*x5")# w = 2
lp_y_all <- rep(".2*x1 + .3*x2 - .1*x3 - .1*x4 - .2*x5", 3)
nlp_y_all <- rep(".7*x1*x1  - .1*x2*x3", 3)
X_all <- c(
  "rnorm(1000, 0, 0.5)",# x1
  "rbeta(1000, 2, .4)",   # x2
  "runif(1000, 0, 0.5)",# x3
  "rweibull(1000,1,2)",  # x4
  "rbinom(1000, 1, .4)"# x5
)
set.seed(111111)
data <- dat_sim(
  nK = 20,
  K = 50,
  n_trt = 3,
  X = X_all,
  eta = 2,
  lp_y = lp_y_all,
  nlp_y  = nlp_y_all,
  align = FALSE,
  lp_w = lp_w_all,
  nlp_w = nlp_w_all,
  lambda = c(1000,2000,3000),
  delta = c(0.5,0.5),
  psi = 1,
  sigma_w = 1,
  sigma_y = 2,
  censor_rate = 0.1
)
}
