% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets-fetch.R
\name{fetch}
\alias{fetch}
\alias{fetch_bunny}
\alias{fetch_spiral_2d}
\alias{clear_data_home}
\title{Remote Data Sets}
\usage{
fetch_bunny(data_folder, accept_license = FALSE)

fetch_spiral_2d(data_folder)

clear_data_home(data_folder)
}
\arguments{
\item{data_folder}{A string specifying a location for storing data ot be used
with GUDHI.}

\item{accept_license}{A boolean specifying whether the user accepts the file
\code{LICENSE} and prevents from printing the corresponding license terms.
Defaults to \code{FALSE}.}
}
\value{
A numeric array storing the points of the corresponding data set.
}
\description{
A collection of function for fetching famous remote data sets.
}
\section{Stanford bunny dataset}{

The \code{\link[=fetch_bunny]{fetch_bunny()}} function returns a numeric array of shape \eqn{35947
\times 3}.
}

\section{\code{spiral_2d} dataset}{

The \code{\link[=fetch_spiral_2d]{fetch_spiral_2d()}} function returns a numeric array of shape
\eqn{114,562 \times 2}.
}

\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
b <- withr::with_tempdir({fetch_bunny(getwd())})
s <- withr::with_tempdir({fetch_spiral_2d(getwd())})
\dontshow{\}) # examplesIf}
}
