% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-vector-methods.R
\name{PersistenceImage}
\alias{PersistenceImage}
\title{Vector Representation: Persistence Image}
\description{
Computes persistence images from a list of persistence diagrams.
A persistence image is a 2D function computed from a persistence diagram by
convolving the diagram points with a weighted Gaussian kernel. The plane is
then discretized into an image with pixels, which is flattened and returned
as a vector. See http://jmlr.org/papers/v18/16-337.html for more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
pei <- PersistenceImage$new()
pei$apply(dgm)
pei$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:VectorRepresentationStep]{rgudhi::VectorRepresentationStep}} -> \code{PersistenceImage}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PersistenceImage-new}{\code{PersistenceImage$new()}}
\item \href{#method-PersistenceImage-clone}{\code{PersistenceImage$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="apply"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-apply'><code>rgudhi::VectorRepresentationStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit'><code>rgudhi::VectorRepresentationStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="fit_transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-fit_transform'><code>rgudhi::VectorRepresentationStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="VectorRepresentationStep" data-id="transform"><a href='../../rgudhi/html/VectorRepresentationStep.html#method-VectorRepresentationStep-transform'><code>rgudhi::VectorRepresentationStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceImage-new"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceImage-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{PersistenceImage}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceImage$new(
  bandwidth = 1,
  weight = ~1,
  resolution = c(20, 20),
  im_range = rep(NA_real_, 4)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bandwidth}}{A numeric value specifying the bandwidth of the Gaussian
kernel. Defaults to \code{1.0}.}

\item{\code{weight}}{A function or a formula coercible into a function via
\code{\link[rlang:as_function]{rlang::as_function()}} specifying the weight function for the
persistence diagram points. Defaults to the constant function \code{~ 1}.
This function must be defined on 2D points, i.e. lists or arrays of the
form \eqn{[p_x,p_y]}.}

\item{\code{resolution}}{An length-1 integer vector specifying the size (in
pixels) of the persistence image. Defaults to \code{rep(20L, 2)}.}

\item{\code{im_range}}{A length-4 numeric vector specifying the two-dimensional
domain for the persistence image, of the form \eqn{[x_{\min}, y_{\min},
  x_{\max}, y_{\max}]}. Defaults to \code{rep(NA, 4)}. If one of the values is
\code{NA}, it can be computed from the persistence diagrams with the
\verb{$fit()} method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{PersistenceImage}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceImage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceImage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceImage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
