% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_from_text.R
\name{network_from_text}
\alias{network_from_text}
\title{Create network objects from 'graph6', 'sparse6', or 'digraph6' symbols}
\usage{
network_from_text(object)
}
\arguments{
\item{object}{character vector of 'graph6', 'sparse6', or 'digraph6' symbols}
}
\value{
A list of 'network' objects.
}
\description{
Create network objects from 'graph6', 'sparse6', or 'digraph6' symbols
}
\examples{
# complete graph in graph6 format
g6 <- "G~~~~{"

# random graph with 15 nodes
s6 <- ":NeF?bsl?aNC"

# random directed graph with 10 nodes
d6 <- "&I???GGGI?_gG??O???"

network_from_text(g6)
network_from_text(c(g6,s6,d6))

}
