% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gexf-js.R
\name{gexf_js_config}
\alias{gexf_js_config}
\alias{plot.gexf}
\title{Visualizing GEXF graph files using gexf-js}
\usage{
gexf_js_config(
  dir,
  graphFile = "network.gexf",
  showEdges = TRUE,
  useLens = FALSE,
  zoomLevel = 0,
  curvedEdges = TRUE,
  edgeWidthFactor = 1,
  minEdgeWidth = 1,
  maxEdgeWidth = 2,
  textDisplayThreshold = 9,
  nodeSizeFactor = 1,
  replaceUrls = TRUE,
  showEdgeWeight = TRUE,
  showEdgeLabel = TRUE,
  sortNodeAttributes = TRUE,
  showId = TRUE,
  showEdgeArrow = TRUE,
  language = FALSE
)

\method{plot}{gexf}(
  x,
  y = NULL,
  graphFile = "network.gexf",
  dir = tempdir(),
  overwrite = TRUE,
  httd.args = list(),
  copy.only = FALSE,
  ...
)
}
\arguments{
\item{dir}{Directory where the files will be copied (tempdir() by default).}

\item{graphFile}{Name of the gexf file.}

\item{showEdges}{Logical scalar. Default state of the "show edges" button (nullable).}

\item{useLens}{Logical scalar. Default state of the "use lens" button (nullable).}

\item{zoomLevel}{Numeric scalar. Default zoom level. At zoom = 0, the graph
should fill a 800x700px zone}

\item{curvedEdges}{Logical scalar. False for curved edges, true for straight
edges this setting can't be changed from the User Interface.}

\item{edgeWidthFactor}{Numeric scalar. Change this parameter for wider or
narrower edges this setting can't be changed from the User Interface.}

\item{minEdgeWidth}{Numeric scalar.}

\item{maxEdgeWidth}{Numeric scalar.}

\item{textDisplayThreshold}{Numeric scalar.}

\item{nodeSizeFactor}{Numeric scalar. Change this parameter for smaller or
larger nodes this setting can't be changed from the User Interface.}

\item{replaceUrls}{Logical scalar. Enable the replacement of Urls by
Hyperlinks this setting can't be changed from the User Interface.}

\item{showEdgeWeight}{Logical scalar. Show the weight of edges in the list
this setting can't be changed from the User Interface.}

\item{showEdgeLabel}{Logical scalar.}

\item{sortNodeAttributes}{Logical scalar. Alphabetically sort node attributes.}

\item{showId}{Logical scalar. Show the id of the node in the list
this setting can't be changed from the User Interface.}

\item{showEdgeArrow}{Logical scalar. Show the edge arrows when the edge is
directed this setting can't be changed from the User Interface.}

\item{language}{Either \code{FALSE}, or a character scalar with any of the
supported languages.}

\item{x}{An object of class \code{gexf}.}

\item{y}{Ignored.}

\item{overwrite}{Logical scalar. When \code{TRUE}, the default, the function
will overwrite all files copied from the template on the destination directory
as specified by \code{dir}.}

\item{httd.args}{Further arguments to be passed to \link[servr:httd]{servr::httd}
from the \CRANpkg{servr} package.}

\item{copy.only}{Logical scalar. When FALSE, the default, the function
will make a call to \code{servr::httd}.}

\item{...}{Further arguments passed to \code{gexf_js_config}}
}
\description{
Using the gexf-js, a JavaScript GEXF viewer, this function allows you to
visualize your GEXF on the browser. The function essentially copies a template
website, the GEXF file, and sets up a configuration file. By default, the
function then starts a webserver using the \code{servr} R package.
}
\details{
Currently, the only languages supported are:
\Sexpr{paste(names(rgexf:::gexf_js_languages), " (", rgexf:::gexf_js_languages, ")", sep="", collapse=", ")}.

An important thing for the user to consider is the fact that the function
only works if there are \code{viz} attributes, this is, color, size, and position.
If the \link{gexf} object's XML document does not have viz attributes, users can
use the following hack:\preformatted{# Turn the object ot igraph and go back
x <- igraph.to.gexf(gexf.to.igraph(x))

# And you are ready to plot!
plot(x)
}

More details on this in the \link{igraph.to.gexf} function.

The files are copied directly from
\Sexpr{system.file("gexf-js", package="rgexf")}. And the
parameters are set up by modifying the following template file:

\Sexpr{system.file("gexf-js/config.js.template", package="rgexf")}

The server is lunched if and only if \code{interactive() == TRUE}.
}
\examples{
if (interactive()) {

path <- system.file("gexf-graphs/lesmiserables.gexf", package="rgexf")
graph <- read.gexf(path)
plot(graph)

}

}
\references{
gexf-js project website https://github.com/raphv/gexf-js.
}
