% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpat_read_txt.R
\name{gpat_read_txt}
\alias{gpat_read_txt}
\title{Read a geoPAT 2.0 text output}
\usage{
gpat_read_txt(x, signature = NULL)
}
\arguments{
\item{x}{A filepath to the geoPAT 2.0 text file}

\item{signature}{A signature used to create the geoPAT 2.0 text output (supported signatures: "lind", "linds")}
}
\value{
data.frame
}
\description{
Read a text output of the geoPAT 2.0 functions into R
}
\examples{
polygon_filepath = system.file("rawdata/Augusta2011_polygon.txt", package = "rgeopat2")
my_polygon = gpat_read_txt(polygon_filepath)

points_filepath = system.file("rawdata/Augusta2011_points.txt", package = "rgeopat2")
my_points = gpat_read_txt(points_filepath)

lind_filepath = system.file("rawdata/Augusta2011_lind.txt", package = "rgeopat2")
my_lind = gpat_read_txt(lind_filepath, signature = "lind")

linds_filepath = system.file("rawdata/Augusta2011_linds.txt", package = "rgeopat2")
my_linds = gpat_read_txt(linds_filepath, signature = "linds")

grid_filepath = system.file("rawdata/Augusta2011_grid100.txt", package = "rgeopat2")
my_grid = gpat_read_txt(grid_filepath)

gridlinds_filepath = system.file("rawdata/Augusta2011_grid_linds.txt", package = "rgeopat2")
my_grid = gpat_read_txt(gridlinds_filepath, signature = "linds")

}
