% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_api.R
\name{ip_api}
\alias{ip_api}
\title{Geolocate IP Addresses Through ip-api.com}
\usage{
ip_api(ip_addresses, as_data_frame = TRUE, delay = FALSE)
}
\arguments{
\item{ip_addresses}{a character vector of IP addresses}

\item{as_data_frame}{whether to return the results as a data.frame or not.
Set to TRUE by default.}

\item{delay}{whether or not to delay each request by 400ms. ip-api.com has a
maximum threshold of 150 requests a minute; if you're parallelising calls, you
might run into this. \code{delay} allows you to set a delay between requests, taking
advantage of parallelisation while avoiding running into this threshold. Set to
FALSE by default}
}
\value{
either a data.frame or a list of vectors. If an IP cannot be geolocated, it
will provide an error message: see the examples for field names and examples of each
possible output.
}
\description{
\code{ip_api} consumes a vector of IP addresses
and geolocates them via \href{http://ip-api.com}{ip-api.com}.
}
\examples{
\dontrun{
#Valid, data.frame output
result <- ip_api("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93")

#Invalid, data.frame output
result <- ip_api("argh")

#Valid list output
result <- ip_api("2607:FB90:426:DC1D:CFC4:4875:8BC2:4D93", as_data_frame = FALSE)

#Invalid list output
result <- ip_api("argh", as_data_frame = FALSE)
}
}
