% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{median_absolute_deviation}
\alias{median_absolute_deviation}
\title{Median absolute deviation}
\usage{
median_absolute_deviation(data)
}
\arguments{
\item{data}{A list of numeric vectors (multi-variables) for median absolute deviation}
}
\value{
A list of numeric vectors from MAD
}
\description{
Median absolute deviation to measure  measure of the variability of a univariate sample of quantitative data
}
\examples{
guerry_path <- system.file("extdata", "Guerry.shp", package = "rgeoda")
guerry <- geoda_open(guerry_path)
guerry_df <- as.data.frame(guerry) # use as data.frame
crm_prs <- guerry_df['Crm_prs'][,1] # get values of variable "crm_prs"
crm_prp <- guerry_df['Crm_prp'][,1] # get values of variable "crm_prp"
data <- list(crm_prs, crm_prp)
median_absolute_deviation(data)
}
