% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accounts.R
\name{accounts}
\alias{accounts}
\title{Get Account Details For All Accounts}
\usage{
accounts(api.key, secret, passphrase)
}
\arguments{
\item{api.key}{Mandatory character value. This is the API key as generated by GDAX. Typically a 32 character value.}

\item{secret}{Mandatory character value. This is the API secret as generated by GDAX. Typically a 88 character value.}

\item{passphrase}{Mandatory character value. This is the passphrase as generated by GDAX. Typically a 11 character value.}
}
\value{
Dataframe with a single row for each account_id, the currency, the current balance, available, holds and profile_id of the user.
}
\description{
This is an auth based function. User must have valid api keys generated by GDAX which must be passed as mandatory arguments. The function takes no additional arguments and returns the account details for all accounts linked to that authenticated user.  The account details currently include information about the currency (fiat or crypto) and the details on the balance (total, available and helpful information for other transactions). All accounts are returned even ones with zero balance.
}
\examples{
\dontrun{
accounts(api.key = your_key, secret = your_api_secret, passphrase = your_api_pass)
}

}
