% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_facet.r
\name{count_facet}
\alias{count_facet}
\title{Facetted count occurrence search.}
\usage{
count_facet(keys = NULL, by = "country", countries = 10,
  removezeros = FALSE)
}
\arguments{
\item{keys}{(numeric) GBIF keys, a vector.}

\item{by}{(character) One of georeferenced, basisOfRecord, country, or
publishingCountry.}

\item{countries}{(numeric) Number of countries to facet on, or a vector of
country names}

\item{removezeros}{(logical) Default is FALSE}
}
\description{
Facetted count occurrence search.
}
\examples{
\dontrun{
# Select number of countries to facet on
count_facet(by='country', countries=3, removezeros = TRUE)
# Or, pass in country names
count_facet(by='country', countries='AR', removezeros = TRUE)

spplist <- c('Geothlypis trichas','Tiaris olivacea','Pterodroma axillaris',
             'Calidris ferruginea','Pterodroma macroptera',
             'Gallirallus australis',
             'Falco cenchroides','Telespiza cantans','Oreomystis bairdi',
             'Cistothorus palustris')
keys <- sapply(spplist,
  function(x) name_backbone(x, rank="species")$usageKey)
count_facet(keys, by='country', countries=3, removezeros = TRUE)
count_facet(keys, by='country', countries=3, removezeros = FALSE)
count_facet(by='country', countries=20, removezeros = TRUE)

# Pass in country names instead
countries <- isocodes$code[1:10]
count_facet(by='country', countries=countries, removezeros = TRUE)

# get occurrences by georeferenced state
## across all records
count_facet(by='georeferenced')

## by keys
count_facet(keys, by='georeferenced')

# by basisOfRecord
count_facet(by="basisOfRecord")
}
}
