% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/networks.r
\name{networks}
\alias{networks}
\title{Networks metadata.}
\usage{
networks(data = "all", uuid = NULL, query = NULL, identifier = NULL,
  identifierType = NULL, limit = 100, start = NULL, ...)
}
\arguments{
\item{data}{The type of data to get. Default is all data.}

\item{uuid}{UUID of the data network provider. This must be specified if data
is anything other than 'all'.}

\item{query}{Query nodes. Only used when data='all'. Ignored otherwise.}

\item{identifier}{The value for this parameter can be a simple string or integer,
e.g. identifier=120. This parameter doesn't seem to work right now.}

\item{identifierType}{Used in combination with the identifier parameter to filter
   identifiers by identifier type. See details. This parameter doesn't seem to
   work right now.}

\item{limit}{Number of records to return. Default: 100. Maximum: 1000.}

\item{start}{Record number to start at. Default: 0. Use in combination with \code{limit} to
page through results.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\description{
Networks metadata.
}
\details{
identifierType options:

\itemize{
 \item {DOI} No description.
 \item {FTP} No description.
 \item {GBIF_NODE} Identifies the node (e.g: 'DK' for Denmark, 'sp2000' for Species 2000).
 \item {GBIF_PARTICIPANT} Participant identifier from the GBIF IMS Filemaker system.
 \item {GBIF_PORTAL} Indicates the identifier originated from an auto_increment column in the
 portal.data_provider or portal.data_resource table respectively.
 \item {HANDLER} No description.
 \item {LSID} Reference controlled by a separate system, used for example by DOI.
 \item {SOURCE_ID} No description.
 \item {UNKNOWN} No description.
 \item {URI} No description.
 \item {URL} No description.
 \item {UUID} No description.
}
}
\examples{
\dontrun{
networks(limit=5)
networks(uuid='16ab5405-6c94-4189-ac71-16ca3b753df7')
networks(data='endpoint', uuid='16ab5405-6c94-4189-ac71-16ca3b753df7')

# Pass on options to httr
library('httr')
res <- networks(limit=5, config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/registry#networks}
}

