% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfm-plots.R
\name{rfm_order_dist}
\alias{rfm_order_dist}
\title{Customers by orders}
\usage{
rfm_order_dist(rfm_table, bar_color = "blue", xaxis_title = "Orders",
  yaxis_title = "Customers", plot_title = "Customers by Orders",
  plot_title_justify = 0.5, print_plot = TRUE)
}
\arguments{
\item{rfm_table}{An object of class \code{rfm_table}.}

\item{bar_color}{Color of the bars.}

\item{xaxis_title}{X axis title.}

\item{yaxis_title}{Y axis title.}

\item{plot_title}{Title of the plot.}

\item{plot_title_justify}{Horizontal justification of the plot title;
0 for left justified and 1 for right justified.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
Bar chart.
}
\description{
Visualize the distribution of customers across orders.
}
\examples{
# using transaction data
analysis_date <- lubridate::as_date('2006-12-31', tz = 'UTC')
rfm_order <- rfm_table_order(rfm_data_orders, customer_id, order_date,
revenue, analysis_date)

# order distribution
rfm_order_dist(rfm_order)

# using customer data
analysis_date <- lubridate::as_date('2007-01-01', tz = 'UTC')
rfm_customer <- rfm_table_customer(rfm_data_customer, customer_id,
number_of_orders, recency_days, revenue, analysis_date)

# order distribution
rfm_order_dist(rfm_customer)

}
