/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.inclusion;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.procedure.PairProcedure;

public class PropInclusion
extends Propagator<GraphVar<?>> {
    private final GraphVar<?>[] g;
    private final IGraphDeltaMonitor[] gdm;
    private final IntProcedure[] prNode;
    private final PairProcedure[] prArc;
    private final GraphEventType[] etNode;
    private final GraphEventType[] etArcs;

    public PropInclusion(GraphVar<?> g1, GraphVar<?> g2) {
        super((Variable[])new GraphVar[]{g1, g2}, (Priority)PropagatorPriority.LINEAR, true);
        this.g = new GraphVar[]{g1, g2};
        this.gdm = new IGraphDeltaMonitor[]{g1.monitorDelta(this), g2.monitorDelta(this)};
        this.prNode = new IntProcedure[]{i -> this.g[1].enforceNode(i, this), i -> {
            if (i < this.g[0].getNbMaxNodes()) {
                this.g[0].removeNode(i, this);
            }
        }};
        this.prArc = new PairProcedure[]{(i, j) -> this.g[1].enforceEdge(i, j, this), (i, j) -> {
            if (i < this.g[0].getNbMaxNodes() && j < this.g[0].getNbMaxNodes()) {
                this.g[0].removeEdge(i, j, this);
            }
        }};
        this.etNode = new GraphEventType[]{GraphEventType.ADD_NODE, GraphEventType.REMOVE_NODE};
        this.etArcs = new GraphEventType[]{GraphEventType.ADD_EDGE, GraphEventType.REMOVE_EDGE};
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j;
        ISetIterator iSetIterator;
        ISet suc;
        int i;
        if (this.g[0].getNbMaxNodes() != this.g[1].getNbMaxNodes()) {
            for (int i2 = this.g[1].getNbMaxNodes(); i2 < this.g[0].getNbMaxNodes(); ++i2) {
                this.g[0].removeNode(i2, this);
            }
        }
        ISet set = this.g[0].getMandatoryNodes();
        ISetIterator iSetIterator2 = set.iterator();
        while (iSetIterator2.hasNext()) {
            i = (Integer)iSetIterator2.next();
            this.g[1].enforceNode(i, this);
            suc = this.g[0].getMandatorySuccessorsOf(i);
            iSetIterator = suc.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                this.g[1].enforceEdge(i, j, this);
            }
        }
        set = this.g[0].getPotentialNodes();
        iSetIterator2 = set.iterator();
        while (iSetIterator2.hasNext()) {
            i = (Integer)iSetIterator2.next();
            if (!this.g[1].getPotentialNodes().contains(i)) {
                this.g[0].removeNode(i, this);
                continue;
            }
            suc = this.g[0].getPotentialSuccessorsOf(i);
            iSetIterator = suc.iterator();
            while (iSetIterator.hasNext()) {
                j = (Integer)iSetIterator.next();
                if (this.g[1].getPotentialSuccessorsOf(i).contains(j)) continue;
                this.g[1].removeEdge(i, j, this);
            }
        }
        this.gdm[0].startMonitoring();
        this.gdm[1].startMonitoring();
    }

    @Override
    public void propagate(int vIdx, int evtmask) throws ContradictionException {
        this.gdm[vIdx].forEachNode(this.prNode[vIdx], this.etNode[vIdx]);
        this.gdm[vIdx].forEachEdge(this.prArc[vIdx], this.etArcs[vIdx]);
    }

    @Override
    public ESat isEntailed() {
        ISetIterator iSetIterator = this.g[0].getMandatoryNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (!this.g[1].getPotentialNodes().contains(i)) {
                return ESat.FALSE;
            }
            ISetIterator iSetIterator2 = this.g[0].getPotentialSuccessorsOf(i).iterator();
            while (iSetIterator2.hasNext()) {
                int j = (Integer)iSetIterator2.next();
                if (this.g[1].getPotentialSuccessorsOf(i).contains(j)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

