% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fb_tbl.R
\name{fb_tbl}
\alias{fb_tbl}
\title{Access a fishbase or sealifebase table}
\usage{
fb_tbl(
  tbl,
  server = c("fishbase", "sealifebase"),
  version = "latest",
  db = NULL,
  collect = TRUE
)
}
\arguments{
\item{tbl}{table name, as it appears in the database. See \code{\link[=fb_tables]{fb_tables()}}
for a list.}

\item{server}{Access data from fishbase or sealifebase?}

\item{version}{Version, see \code{\link[=available_releases]{available_releases()}}}

\item{db}{database connection, deprecated}

\item{collect}{should we return an in-memory table? Generally best to leave
as TRUE unless RAM is too limited.  A remote table can be used with most
dplyr functions (filter, select, joins, etc) to further refine.}
}
\description{
Please note that rfishbase accesses static snapshots of the raw database
tables used by FishBase and Sealifebase websites. Because these are static
snapshots, they may lag behind the latest available information on the web
interface, but should provide stable results.
}
\details{
Please also note that the website pages are not organized precisely along
the lines of these tables.  A given page for a species may draw on data from
multiple tables, and sometimes presents the data in a processed or summarized
form.  Following RDB design, it is often
necessary to join multiple tables.  Other data cleaning steps are sometimes
necessary as well.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
fb_tbl("species")
\dontshow{\}) # examplesIf}
}
