% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/population_dynamics.R
\name{length_weight}
\alias{length_weight}
\alias{poplw}
\title{length_weight}
\usage{
length_weight(species_list, fields = NULL, limit = 200,
  server = getOption("FISHBASE_API", FISHBASE_API), ...)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species").}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned. This option can be used to the amount
of data transfered over the network if only certain columns are needed.}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}

\item{...}{additional arguments to httr::GET}
}
\value{
a table of length_weight information by species; see details
}
\description{
The LENGTH-WEIGHT table presents the a and b values of over 5,000
length-weight relationships of the form W = a x Lb, pertaining to about over 2,000 fish species.
}
\details{
See references for official documentation.  From FishBase.org:
Length-weight relationships are important in fisheries science,
notably to raise length-frequency samples to total catch, or to
estimate biomass from underwater length observations.
The units of length and weight in FishBase are centimeter and gram, respectively.
Thus when length-weight relationships are not in cm-g, the intercept 'a'
is transformed as follows:

a'(cm, g) = a (mm, g)*10^b
a'(cm, g) = a (cm, kg)*1000
a'(cm, g) = a (mm, mg)*10^b/1000
a'(cm, g) = a (mm, kg)*10^b*1000

However, published length-weight relationships are sometimes difficult to use,
as they may be based on a length measurement type (e.g., fork length) different
from ones length measurements (expressed e.g., as total length).
Therefore, to facilitate conversion between length types, an additional
LENGTH-LENGTH table, #' presented below, was devised which presents linear
regressions or ratios linking length types (e.g., FL vs. TL).
We included a calculated field with the weight of a 10 cm fish (which
should be in the order of 10 g for normal, fusiform shaped fish),
to allow identification of gross errors, given knowledge of the body
form of a species.
}
\examples{
\donttest{
length_weight("Oreochromis niloticus")
}
}
\references{
http://www.fishbase.org/manual/english/fishbasethe_length_weight_table.htm
}

