% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/trophic_ecology.R
\name{ecology}
\alias{ecology}
\title{ecology}
\usage{
ecology(species_list, fields = NULL, limit = 1,
  server = getOption("FISHBASE_API", FISHBASE_API))
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species").}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned. This option can be used to the amount
of data transfered over the network if only certain columns are needed.}

\item{limit}{The maximum number of matches from a single API call (e.g. per species). Function
will warn if this needs to be increased, otherwise can be left as is.}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use http://fishbase.ropensci.org/sealifebase}
}
\value{
a table of species ecology data
}
\description{
ecology
}
\details{
By default, will only return one entry (row) per species.  Increase limit to
get multiple returns for different stocks of the same species, though often data is either
identical to the first or simply missing in the additional stocks.
}
\examples{
\donttest{
ecology("Oreochromis niloticus")

## trophic levels and standard errors for a list of species
ecology(c("Oreochromis niloticus", "Salmo trutta"),
        fields=c("SpecCode", "FoodTroph", "FoodSeTroph", "DietTroph", "DietSeTroph"))
}
}
\references{
http://www.fishbase.org/manual/english/fishbasethe_ecology_table.htm
}

