% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bivariate.partialDependence.R
\name{bivariate.partialDependence}
\alias{bivariate.partialDependence}
\title{Bivariate partial-dependency plot}
\usage{
bivariate.partialDependence(x, pred.data, v1, v2, grid.size = 20,
  which.class = 2, plot = TRUE, col.ramp = c("#ffffff", "#2a2a2a"),
  ncols = 20, ...)
}
\arguments{
\item{x}{random forest object}

\item{pred.data}{data.frame of independent variables used in model}

\item{v1}{Variable 1 used in partial dependency}

\item{v2}{Variable 2 used in partial dependency}

\item{grid.size}{Number of grid cells (NxN) to integrate partial dependency for}

\item{which.class}{Index of class probability (only if classification)}

\item{plot}{(TRUE/FALSE) Plot 3D surface}

\item{col.ramp}{Colors used in building color ramp}

\item{ncols}{Number of colors in color ramp}

\item{...}{Arguments passed to persp}
}
\value{
A list object with vectors of v1 (p1) and v2 (p2) and a matrix (estimate), estimate of the averaged estimates.
}
\description{
Bivariate partial dependence provides a graphical depiction of the marginal effect of two variables on the class probability (classification) or response (regression)
}
\note{
In deriving the partial-dependence, at each plotted point, the background variables are held at their median values
}
\examples{
 library(randomForest)
   data(iris)
   iris$Species <- ifelse( iris$Species == "versicolor", 1, 0 ) 
    
 # Add some noise
 idx1 <- which(iris$Species \%in\% 1)
 idx0 <- which( iris$Species \%in\% 0)
   iris$Species[sample(idx1, 2)] <- 0
   iris$Species[sample(idx0, 2)] <- 1
  
 # Specify model  
 y = iris[,"Species"] 
 x = iris[,1:4]
 
 set.seed(4364)  
 ( rf.mdl1 <- randomForest(x=x, y=factor(y)) )
 
 
 ( bvpd <- bivariate.partialDependence(rf.mdl1, iris, 
                   v1 = "Petal.Length", v2 = "Petal.Width", shade = 0.6,
                   grid.size = 20, ncols=100, border=NA, col.ramp=c("green","blue") ) ) 
	
}
\references{
Friedman, J.H. (2001) Greedy Function Approximation:  A Gradient Boosting Machine. Annals of Statistics 19(1)

Evans J.S., M.A. Murphy, Z.A. Holden, S.A. Cushman (2011). Modeling species distribution and change using Random Forests CH.8 in Predictive Modeling in Landscape Ecology eds Drew, CA, Huettmann F, Wiersma Y. Springer

Baruch-Mordo, S., J.S. Evans, J. Severson, J. D. Naugle, J. Kiesecker, J. Maestas, & M.J. Falkowski (2013) Saving sage-grouse from the trees: A proactive solution to reducing a key threat to a candidate species Biological Conservation 167:233-241
}
\seealso{
\code{\link[graphics]{persp}} for persp ... plotting options
}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
