% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balancedSampsize.R
\name{balancedSampsize}
\alias{balancedSampsize}
\title{Balanced Sample Size}
\usage{
balancedSampsize(y, pct = 0.5)
}
\arguments{
\item{y}{character, numeric, or factor vector containing classes of 
response variable. Values will be treated as unique for computing class 
frequencies.}

\item{pct}{percent of smallest class frequency for \code{sampsize} vector.}
}
\value{
a named vector of sample sizes as long as the number of classes.
}
\description{
Create a vector of balanced (equal) sample sizes for use in 
  the \code{sampsize} argument of \code{\link{rfPermute}} or 
  \code{\link[randomForest]{randomForest}} for a classification model. The 
  values are derived from a percentage of the smallest class sample size.
}
\examples{
data(mtcars)

# A balanced model with default half of smallest class size
sampsize_0.5 <- balancedSampsize(mtcars$am)
sampsize_0.5

rfPermute(factor(am) ~ ., mtcars, replace = FALSE, sampsize = sampsize_0.5)

# A balanced model with one quarter of smallest class size
sampsize_0.25 <- balancedSampsize(mtcars$am, pct = 0.25)
sampsize_0.25

rfPermute(factor(am) ~ ., mtcars, replace = FALSE, sampsize = sampsize_0.25)


}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
