% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusionMatrix.R
\name{confusionMatrix}
\alias{confusionMatrix}
\alias{plotConfMat}
\title{Confusion Matrix}
\usage{
confusionMatrix(x, conf.level = 0.95, threshold = NULL)

plotConfMat(x, title = NULL, plot = TRUE)
}
\arguments{
\item{x}{a \code{rfPermute} or \code{randomForest} model object.}

\item{conf.level}{confidence level for the \code{\link{binom.test}} 
confidence interval}

\item{threshold}{threshold to test observed classification 
probability against. Should be a number between 0 and 1. 
If not \code{NULL}, the output matrix will have extra 
columns giving the one-tailed probability that the true correct 
classification is >= \code{threshold}.}

\item{title}{a title for the plot.}

\item{plot}{display the plot?}
}
\description{
Generate a confusion matrix for Random Forest classification 
  models with error rates translated into percent correctly classified, 
  and columns for confidence intervals added.
}
\examples{
library(randomForest)
data(mtcars)

rf <- randomForest(factor(am) ~ ., mtcars)
confusionMatrix(rf)

confusionMatrix(rf, conf.level = 0.75)

confusionMatrix(rf, threshold = 0.7)
confusionMatrix(rf, threshold = 0.8)
confusionMatrix(rf, threshold = 0.95)

}
\seealso{
\code{\link{classPriors}}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
