% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impHeatmap.R
\name{impHeatmap}
\alias{impHeatmap}
\title{Importance Heatmap}
\usage{
impHeatmap(rf, n = NULL, ranks = TRUE, plot = TRUE, xlab = NULL,
  ylab = NULL, scale = TRUE, alpha = 0.05)
}
\arguments{
\item{rf}{an object inheriting from \code{\link{randomForest}}.}

\item{n}{Plot \code{n} most important predictors.}

\item{ranks}{plot ranks instead of actual importance scores?}

\item{plot}{print the plot?}

\item{xlab, ylab}{labels for the x and y axes.}

\item{scale}{For permutation based measures, should the measures be divided 
their "standard errors"?}

\item{alpha}{a number specifying the critical alpha for identifying 
predictors with importance scores significantly different from random. 
This parameter is only relevant if \code{rf} is a \code{\link{rfPermute}}
object with p-values. Importance measures with p-values less than alpha 
will be denoted in the heatmap by a black border. If set to \code{NULL}, 
no border is drawn.}
}
\value{
the \code{ggplot} object is invisibly returned.
}
\description{
Plot heatmap of importance scores or ranks from a 
  classification model
}
\details{
\code{rf} must be a classification model run with 
  \code{importance = TRUE}.
}
\examples{
data(mtcars)

# A randomForest model
rf <- randomForest(factor(am) ~ ., mtcars, importance = TRUE)
importance(rf)
impHeatmap(rf, xlab = "Transmission", ylab = "Predictor")

# An rfPermute model with significant predictors identified
rp <- rfPermute(factor(am) ~ ., mtcars, nrep = 100, num.cores = 1)
impHeatmap(rp, xlab = "Transmission", ylab = "Predictor")

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
