% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match.R
\name{re_substitutes}
\alias{re_substitutes}
\title{Substitute regular expressions in a string with another string.}
\usage{
re_substitutes(data, pattern, replacement, global = FALSE, options = NULL,
  ...)
}
\arguments{
\item{data}{character vector to substitute}

\item{pattern}{regular expression to match}

\item{replacement}{replacement text to use}

\item{global}{substitute all occurrences}

\item{options}{option flags}

\item{...}{options passed to sub or gsub}
}
\description{
Substitute regular expressions in a string with another string.
}
\examples{
string <- c("this is a Test", "string")
re_substitutes(string, "test", "not a test", options = "insensitive")
re_substitutes(string, "i", "x", global = TRUE)
re_substitutes(string, "(test)", "not a \\\\1", options = "insensitive")
}
\seealso{
\code{\link{regexp}} Section "Perl-like Regular Expressions" for a
discussion of the supported options
}

