% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rprior.R
\name{rprior_quant}
\alias{rprior_quant}
\title{Prior simulation of GEV parameters - prior on quantile scale}
\usage{
rprior_quant(n, prob, shape, scale, lb = NULL, lb_prob = 0.001)
}
\arguments{
\item{n}{A numeric scalar. The size of sample required.}

\item{prob}{A numeric vector of length 3. Exceedance probabilities
corresponding to the quantiles used to specify the prior distribution.
The values should \emph{decrease} with the index of the vector.
If not, the values in \code{prob} will be sorted into decreasing order
without warning.}

\item{shape}{A numeric vector of length 3. Respective shape parameters of
the gamma priors for the quantile differences.}

\item{scale}{A numeric vector of length 3. Respective scale parameters of
the gamma priors for the quantile differences.}

\item{lb}{A numeric scalar.  If this is not \code{NULL} then the simulation
is constrained so that \code{lb} is an approximate lower bound on the
GEV variable.  Specifically, only simulated GEV parameter values for
which the 100\code{lb_prob}\% quantile is greater than \code{lb} are
retained.}

\item{lb_prob}{A numeric scalar.  The non-exceedance probability involved
in the specification of \code{lb}.  Must be in (0,1).  If \code{lb=NULL}
then \code{lb_prob} is not used.}
}
\value{
An \code{n} by 3 numeric matrix.
}
\description{
Simulates from the prior distribution for GEV parameters proposed in
Coles and Tawn (1996), based on independent gamma priors for differences
between quantiles.
}
\details{
The simulation is based on the way that the prior is constructed.
  See
  \href{https://doi.org/10.2307/2986068}{Coles and Tawn (1996)},
  \href{https://doi.org/10.1201/b19721}{Stephenson (1996)}
  or the evdbayes user guide
  for details of the construction of the prior. First, the quantile
  differences are simulated from the specified gamma distributions.
  Then the simulated quantiles are calculated. Then the GEV location,
  scale and shape parameters that give these quantile values are found,
  by solving numerically a set of three non-linear equations in which the
  GEV quantile function evaluated at the values in \code{prob} is equated
  to the simulated quantiles.  This is reduced to a one-dimensional
  optimisation over the GEV shape parameter.
}
\examples{
pr <- 10 ^ -(1:3)
sh <- c(38.9, 7.1, 47)
sc <- c(1.5, 6.3, 2.6)
x <- rprior_quant(n = 1000, prob = pr, shape = sh, scale = sc)
x <- rprior_quant(n = 1000, prob = pr, shape = sh, scale = sc, lb = 0)
}
\references{
Coles, S. G. and Tawn, J. A. (1996) A Bayesian analysis of
  extreme rainfall data. \emph{Appl. Statist.}, \strong{45}, 463-478.
  \url{https://doi.org/10.2307/2986068}.

Stephenson, A. 2016. Bayesian Inference for Extreme Value
  Modelling. In \emph{Extreme Value Modeling and Risk Analysis: Methods and
  Applications}, edited by D. K. Dey and J. Yan, 257-80. London:
  Chapman and Hall. \url{https://doi.org/10.1201/b19721}
}
\seealso{
\code{\link[evdbayes:prior]{prior.quant}} to set this prior
  using the evdbayes package.

\code{\link[evdbayes:prior]{posterior}}: evdbayes function that
  can sample from this prior distribution (using MCMC) if the argument
  \code{lh = "none"} is given.

\code{\link{rpost}} and \code{\link{rpost_rcpp}} for sampling
  from an extreme value posterior distribution.
}
