% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_survey_variables.R
\name{harmonize_survey_variables}
\alias{harmonize_survey_variables}
\title{Read a survey from a CSV file}
\usage{
harmonize_survey_variables(
  crosswalk_table,
  subset_name = "subset",
  survey_list = NULL,
  survey_paths = NULL,
  import_path = NULL,
  export_path = NULL
)
}
\arguments{
\item{crosswalk_table}{A crosswalk table created with
[crosswalk_table_create()].}

\item{subset_name}{Character string appended to filenames of
subsetted surveys. Defaults to `"subset"`.}

\item{survey_list}{A list containing surveys of class survey.}

\item{survey_paths}{Optional character vector of file paths to surveys.}

\item{import_path}{Optional base directory used to resolve `survey_paths`.}

\item{export_path}{Optional directory where subsetted surveys are
exported to}
}
\value{
An object of class `"survey"`, which is a data frame with attached
survey- and dataset-level metadata.
}
\description{
Import a survey stored in a CSV file and return it as a survey object
with attached dataset- and survey-level metadata.
}
\details{
The CSV file is read using [utils::read.csv()]. Character variables
with more than one unique value are automatically converted to
labelled factors. A unique row identifier is added and labelled.


If the file cannot be read, an empty survey object is returned with
a warning.

If a column named `"X"` is present (commonly created by
`write.csv()`), it is removed automatically.
}
\examples{
# Create a temporary CSV file from an example survey
path <- system.file("examples", "ZA7576.rds", 
                    package = "retroharmonize")
survey <- read_rds(path)

tmp <- tempfile(fileext = ".csv")
write.csv(survey, tmp, row.names = FALSE)

# Read the CSV file back as a survey
re_read <- read_csv(
  file = tmp,
  id = "ZA7576",
  doi = "10.0000/example"
)

}
\seealso{
[read_rds()] for importing surveys from RDS files,
[survey_df()] for constructing survey objects manually.

Other import functions: 
\code{\link{pull_survey}()},
\code{\link{read_csv}()},
\code{\link{read_dta}()},
\code{\link{read_rds}()},
\code{\link{read_spss}()},
\code{\link{read_surveys}()}
}
\concept{import functions}
