% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmonize_survey_values.R
\name{harmonize_survey_values}
\alias{harmonize_survey_values}
\alias{harmonize_waves}
\title{Harmonize values in surveys}
\usage{
harmonize_survey_values(survey_list, .f, status_message = FALSE)

harmonize_waves(waves, .f, status_message = FALSE)
}
\arguments{
\item{survey_list}{A list of surveys (data frames). In earlier versions this argument was called
\code{waves}.}

\item{.f}{A function applied to each labelled variable
(class \code{"retroharmonize_labelled_spss_survey"}). The function must not
change the length of the input vector.}

\item{status_message}{Logical. If \code{TRUE}, prints the identifier of each survey as it is
processed.}

\item{waves}{A list of surveys. Deprecated.}
}
\value{
A data frame containing the row-wise combination of all surveys, with
harmonized labelled variables and preserved attributes describing the
original surveys.
}
\description{
Harmonize value codes and value labels across multiple surveys and
combine them into a single data frame.
}
\details{
The function first aligns the structure of all surveys by ensuring that
they contain the same set of variables. Missing variables are added and
filled with appropriate missing values depending on their type.

Variables of class \code{"retroharmonize_labelled_spss_survey"} are then
harmonized by applying a user-supplied function \code{.f} to each variable
separately within each survey.

The harmonization function \code{.f} must return a vector of the same length
as its input. If \code{.f} returns \code{NULL}, the original variable is kept
unchanged.

Prior to version 0.2.0 this function was called \code{harmonize_waves}.

The earlier form \code{harmonize_waves} is deprecated.
The function is currently called \code{\link{harmonize_waves}}.
}
\examples{
\donttest{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_files <- dir(examples_dir, pattern = "\\\\.rds$", full.names = TRUE)

surveys <- read_surveys(
  survey_files,
  export_path = NULL
)

# Keep only supported variable types
surveys <- lapply(
  surveys,
  function(s) {
    s[, vapply(
      s,
      function(x) inherits(x, c(
        "retroharmonize_labelled_spss_survey",
        "numeric",
        "character",
        "Date"
      )),
      logical(1)
    )]
  }
)

# Identity harmonization (no-op)
harmonized <- harmonize_survey_values(
  survey_list = surveys,
  .f = function(x) x,
  status_message = FALSE
)

head(harmonized)
}
}
\seealso{
Other harmonization functions: 
\code{\link{collect_val_labels}()},
\code{\link{crosswalk_surveys}()},
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_values}()},
\code{\link{harmonize_var_names}()},
\code{\link{is.crosswalk_table}()},
\code{\link{label_normalize}()}
}
\concept{harmonization functions}
