% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_waves.R
\name{merge_waves}
\alias{merge_waves}
\title{Merge waves}
\usage{
merge_waves(waves, var_harmonization)
}
\arguments{
\item{waves}{A list of surveys}

\item{var_harmonization}{Metadata of surveys, including at least
\code{filename}, \code{var_name_orig}, \code{var_name}, \code{var_label}.}
}
\value{
A list of surveys with harmonized names and variable labels.
}
\description{
Merge a list of surveys into a list with harmonized variable names,
variable labels and survey identifiers.
}
\examples{
\donttest{
examples_dir <- system.file("examples", package = "retroharmonize")
survey_list <- dir(examples_dir)[grepl("\\\\.rds", dir(examples_dir))]

example_surveys <- read_surveys(
  file.path( examples_dir, survey_list), 
  save_to_rds = FALSE)
    
metadata <- lapply ( X = example_surveys, FUN = metadata_create )
metadata <- do.call(rbind, metadata)
 
to_harmonize <- metadata \%>\%
  dplyr::filter ( var_name_orig \%in\% 
                  c("rowid", "w1") |
                  grepl("trust ", label_orig ) ) \%>\%
  dplyr::mutate ( var_label = var_label_normalize(label_orig) ) \%>\%
  dplyr::mutate ( var_name = val_label_normalize(var_label) )

merge_waves ( example_surveys, to_harmonize )
}
}
\seealso{
survey

Other harmonization functions: 
\code{\link{collect_val_labels}()},
\code{\link{harmonize_na_values}()},
\code{\link{harmonize_values}()},
\code{\link{harmonize_var_names}()},
\code{\link{harmonize_waves}()},
\code{\link{label_normalize}()},
\code{\link{na_range_to_values}()},
\code{\link{suggest_permanent_names}()},
\code{\link{suggest_var_names}()}
}
\concept{harmonization functions}
