% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integralDivision.R
\name{integralDivision}
\alias{integralDivision}
\title{Integral division of two polynomials}
\usage{
integralDivision(qspray1, qspray2, check = TRUE)
}
\arguments{
\item{qspray1, qspray2}{two \code{qspray} polynomials having at most nine
variables}

\item{check}{Boolean, whether to check that \code{qspray2} divides
\code{qspray1}}
}
\value{
If \code{check=TRUE}, this returns \code{NULL} if \code{qspray2}
  does not divide \code{qspray1}, otherwise this returns a \code{qspray}
  polynomial, the quotient of \code{qspray1} by \code{qspray2}.
  If \code{check=FALSE}, this always returns a \code{qspray} polynomial,
  which is the quotient of \code{qspray1} by \code{qspray2} if
  \code{qspray2} divides \code{qspray1}, otherwise it is an undefined
  polynomial. So you can use \code{check=FALSE} only when you are sure that
  \code{qspray2} divides \code{qspray1}.
}
\description{
Integral division (division without remainder) of two
  polynomials with rational coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
y <- qlone(2)
q <- x^2 + 2*x*y + 1
qspray1 <- q * (x^4 + y^2 + 2)
qspray2 <- x^4 + y^2 + 2
integralDivision(qspray1, qspray2) == q # should be TRUE
}
\seealso{
\code{\link{univariateDivision}},
  \code{\link[qspray]{qsprayDivision}}.
}
