/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.objectives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chocosolver.solver.Solution;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.search.limits.TimeCounter;
import org.chocosolver.solver.search.loop.lns.INeighborFactory;
import org.chocosolver.solver.search.strategy.Search;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.criteria.Criterion;
import org.restopt.RestoptProblem;
import org.restopt.RestoptSolution;
import org.restopt.exception.RestoptException;

public abstract class AbstractRestoptObjective {
    private static Set<String> SEARCH_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("RANDOM", "DOM_OVER_W_DEG", "DOM_OVER_W_DEG_REF", "MIN_DOM_LB", "MIN_DOM_UB", "ACTIVITY_BASED", "CONFLICT_HISTORY", "FAILURE_RATE", "FAILURE_LENGTH")));
    protected RestoptProblem problem;
    protected IntVar objective;
    protected int timeLimit;
    protected boolean verbose;
    protected boolean maximize;
    protected long totalRuntime;
    protected String search;
    protected boolean lns;
    protected BoolVar[] decisionVars;
    protected int optimalValue;
    protected boolean provenOptimal;

    public AbstractRestoptObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize, String search, boolean lns) {
        this.problem = problem;
        this.timeLimit = timeLimit;
        this.verbose = verbose;
        this.maximize = maximize;
        this.provenOptimal = false;
        this.search = search;
        this.lns = lns;
        this.decisionVars = null;
    }

    public AbstractRestoptObjective(RestoptProblem problem, int timeLimit, boolean verbose, boolean maximize) {
        this(problem, timeLimit, verbose, maximize, "", false);
    }

    public boolean isProvenOptimal() {
        return this.provenOptimal;
    }

    public int getOptimalValue() {
        return this.optimalValue;
    }

    public IntVar getObjective() {
        return this.objective;
    }

    public void initDecisionVars() {
        this.decisionVars = new BoolVar[this.problem.getAvailablePlanningUnits().length];
        for (int i = 0; i < this.decisionVars.length; ++i) {
            this.decisionVars[i] = this.problem.getModel().setBoolView(this.problem.getRestoreSetVar(), this.problem.getAvailablePlanningUnits()[i]);
        }
    }

    public void setSearch() {
        if (SEARCH_KEYS.contains(this.search)) {
            if (this.decisionVars == null) {
                this.initDecisionVars();
            }
            switch (this.search) {
                case "RANDOM": {
                    this.problem.getModel().getSolver().setSearch(Search.randomSearch(this.decisionVars, System.currentTimeMillis()));
                    break;
                }
                case "DOM_OVER_W_DEG": {
                    this.problem.getModel().getSolver().setSearch(Search.domOverWDegSearch(this.decisionVars));
                    break;
                }
                case "DOM_OVER_W_DEG_REF": {
                    this.problem.getModel().getSolver().setSearch(Search.domOverWDegRefSearch(this.decisionVars));
                    break;
                }
                case "MIN_DOM_LB": {
                    this.problem.getModel().getSolver().setSearch(Search.minDomLBSearch(this.decisionVars));
                    break;
                }
                case "MIN_DOM_UB": {
                    this.problem.getModel().getSolver().setSearch(Search.minDomUBSearch(this.decisionVars));
                    break;
                }
                case "ACTIVITY_BASED": {
                    this.problem.getModel().getSolver().setSearch(Search.activityBasedSearch(this.decisionVars));
                    break;
                }
                case "CONFLICT_HISTORY": {
                    this.problem.getModel().getSolver().setSearch(Search.conflictHistorySearch(this.decisionVars));
                    break;
                }
                case "FAILURE_RATE": {
                    this.problem.getModel().getSolver().setSearch(Search.failureRateBasedSearch(this.decisionVars));
                    break;
                }
                case "FAILURE_LENGTH": {
                    this.problem.getModel().getSolver().setSearch(Search.failureLengthBasedSearch(this.decisionVars));
                }
            }
        } else {
            if (!this.search.equals("") && !this.search.equals("DEFAULT")) {
                System.out.println("Warning: the search strategy '" + this.search + "' does not exist. Setting default search");
            }
            this.problem.getModel().getSolver().setSearch(Search.setVarSearch(this.problem.getRestoreSetVar()));
        }
    }

    public void configureSearch() {
        this.setSearch();
        if (this.lns) {
            if (this.search.equals("ACTIVITY_BASED")) {
                System.out.println("Warning: the search strategy '" + this.search + "' is not compatible with LNS. LNS will not be activated.");
            } else {
                if (this.decisionVars == null) {
                    this.initDecisionVars();
                }
                this.problem.getModel().getSolver().setLNS(INeighborFactory.random(this.decisionVars));
            }
        }
    }

    public abstract void initObjective();

    public abstract String getInitialValueMessage();

    public abstract String[] getAdditionalKeys();

    public abstract Map<String, String> appendCharacteristics(Solution var1);

    public abstract List<String[]> appendMessages();

    public List<Solution> solve(int nbSolutions, int timeLimit, double optimalityGap) throws RestoptException {
        ArrayList<Solution> solutions;
        long t = System.currentTimeMillis();
        this.configureSearch();
        if (nbSolutions == 1) {
            solutions = new ArrayList();
            TimeCounter timeCounter = new TimeCounter(this.problem.getModel(), (long)((double)timeLimit * 1.0E9));
            Solution solution = this.problem.getModel().getSolver().findOptimalSolution(this.objective, this.maximize, timeCounter);
            this.optimalValue = this.problem.getModel().getSolver().getObjectiveManager().getBestSolutionValue().intValue();
            if (solution != null) {
                solutions.add(solution);
            }
            if (String.valueOf(this.problem.getModel().getSolver().getSearchState()) == "TERMINATED") {
                this.provenOptimal = true;
            }
        } else {
            solutions = this.findNOptimalSolutions(this.objective, this.maximize, nbSolutions, timeLimit, optimalityGap);
        }
        this.totalRuntime = System.currentTimeMillis() - t;
        return solutions;
    }

    public List<Solution> solve(int nbSolutions, double optimalityGap) throws RestoptException {
        ArrayList<Solution> solutions;
        long t = System.currentTimeMillis();
        this.configureSearch();
        if (nbSolutions == 1) {
            solutions = new ArrayList();
            Solution opt = this.problem.getModel().getSolver().findOptimalSolution(this.objective, this.maximize, new Criterion[0]);
            if (opt != null) {
                this.provenOptimal = true;
                solutions.add(opt);
                this.optimalValue = this.problem.getModel().getSolver().getObjectiveManager().getBestSolutionValue().intValue();
            }
        } else {
            solutions = this.findNOptimalSolutions(this.objective, this.maximize, nbSolutions, 0, optimalityGap);
        }
        this.totalRuntime = System.currentTimeMillis() - t;
        return solutions;
    }

    public List<RestoptSolution> findOptimalSolution(int nbSolutions, double optimalityGap) throws RestoptException {
        List<Solution> solutions;
        this.initObjective();
        Solver solver = this.problem.getModel().getSolver();
        if (this.verbose) {
            System.out.println(this.getInitialValueMessage());
            solver.showShortStatistics();
        }
        if ((solutions = this.timeLimit > 0 ? this.solve(nbSolutions, this.timeLimit, optimalityGap) : this.solve(nbSolutions, optimalityGap)).size() == 0) {
            if (this.verbose) {
                System.out.println("There is no solution satisfying the constraints");
            }
            return new ArrayList<RestoptSolution>();
        }
        ArrayList<RestoptSolution> restoptSolutions = new ArrayList<RestoptSolution>();
        for (Solution s : solutions) {
            restoptSolutions.add(new RestoptSolution(this.problem, this, s));
        }
        return restoptSolutions;
    }

    protected List<Solution> findNSolutions(int nbSolutions, int timeLimit) {
        Solver solver = this.problem.getModel().getSolver();
        solver.getModel().clearObjective();
        TimeCounter timeCounter = new TimeCounter(this.problem.getModel(), (long)((double)timeLimit * 1.0E9));
        if (this.timeLimit > 0) {
            solver.addStopCriterion(timeCounter);
        }
        ArrayList<Solution> solutions = new ArrayList<Solution>();
        for (int i = 0; solver.solve() && (i < nbSolutions || nbSolutions == -1); ++i) {
            solutions.add(new Solution(solver.getModel(), new Variable[0]).record());
        }
        solver.removeStopCriterion(timeCounter);
        return solutions;
    }

    private List<Solution> findNOptimalSolutions(IntVar objective, boolean maximize, int nbSolutions, int timeLimit, double optimalityGap) throws RestoptException {
        Solution optimal;
        if (optimalityGap < 0.0 || optimalityGap > 1.0) {
            throw new RestoptException("Optimality gap must be comprised between 0 and 1");
        }
        Solver solver = this.problem.getModel().getSolver();
        boolean defaultS = solver.getSearch() == null;
        TimeCounter timeCounter = null;
        this.provenOptimal = false;
        if (timeLimit > 0) {
            timeCounter = new TimeCounter(this.problem.getModel(), (long)((double)timeLimit * 1.0E9));
            optimal = solver.findOptimalSolution(objective, maximize, timeCounter);
        } else {
            optimal = solver.findOptimalSolution(objective, maximize, new Criterion[0]);
        }
        this.optimalValue = solver.getObjectiveManager().getBestSolutionValue().intValue();
        if (String.valueOf(solver.getSearchState()) != "TERMINATED") {
            ArrayList<Solution> sols = new ArrayList<Solution>();
            sols.add(optimal);
            return sols;
        }
        this.provenOptimal = true;
        int nTimeLimit = Math.round((float)timeLimit - solver.getTimeCount());
        if (!solver.isStopCriterionMet() && solver.getSolutionCount() > 0L) {
            if (timeCounter != null) {
                solver.removeStopCriterion(timeCounter);
            }
            solver.reset();
            solver.getModel().clearObjective();
            String operator = maximize ? ">=" : "<=";
            int optWithGap = (int)(maximize ? Math.ceil((double)this.optimalValue * (1.0 - optimalityGap)) : Math.floor((double)this.optimalValue * (1.0 + optimalityGap)));
            Constraint forceOptimal = solver.getModel().arithm(objective, operator, optWithGap);
            forceOptimal.post();
            if (defaultS) {
                Search.defaultSearch(solver.getModel());
            }
            List<Solution> solutions = timeLimit > 0 ? this.findNSolutions(nbSolutions, nTimeLimit) : this.findNSolutions(nbSolutions, -1);
            solver.getModel().unpost(forceOptimal);
            return solutions;
        }
        solver.removeStopCriterion(timeCounter);
        return Collections.emptyList();
    }

    public long getTotalRuntime() {
        return this.totalRuntime;
    }
}

