/*
 * Decompiled with CFR 0.152.
 */
package org.restopt.grid.regular.square;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.objects.setDataStructures.SetFactory;
import org.restopt.RasterConnectivityFinder;
import org.restopt.exception.RestoptException;
import org.restopt.grid.regular.square.GroupedGrid;

public class PartialRegularGroupedAggGrid
extends GroupedGrid {
    private int[] sizeCells;
    private final int nbGroups;
    private final ISet[] groups;
    private ISet[] aggregates;
    private int nbAggregates;
    private final int nbGroupedCells;
    private final ISet groupedCells;
    private final Map<Integer, Integer> gridIdToGroupedId;
    private final int aggregationFactor;

    public PartialRegularGroupedAggGrid(int nbRows, int nbCols, int[] toDiscard, RasterConnectivityFinder groupGraph, int aggregationFactor) {
        super(nbRows, nbCols, toDiscard);
        int cc;
        this.aggregationFactor = aggregationFactor;
        this.nbGroupedCells = groupGraph.getNbNodes();
        this.groupedCells = SetFactory.makeConstantSet(groupGraph.getNodesRasterIdx());
        this.nbGroups = groupGraph.getNBCC();
        this.sizeCells = new int[super.getNbCells() - this.nbGroupedCells + this.nbGroups];
        this.groups = new ISet[this.nbGroups];
        this.gridIdToGroupedId = new HashMap<Integer, Integer>();
        int nbMaxAggregates = (int)(Math.ceil(1.0 * (double)nbCols / (double)aggregationFactor) * Math.ceil(1.0 * (double)nbRows / (double)aggregationFactor));
        this.nbAggregates = 0;
        this.aggregates = new ISet[nbMaxAggregates];
        for (int i = 0; i < nbMaxAggregates; ++i) {
            int[] agg = IntStream.of(this.getMaxAggregate(i)).filter(v -> !this.isGrouped(this.getCompleteIndex(v))).toArray();
            if (agg.length <= 0) continue;
            this.aggregates[this.nbAggregates] = SetFactory.makeConstantSet(agg);
            for (int v2 : agg) {
                this.gridIdToGroupedId.put(v2, this.nbAggregates + this.nbGroups);
            }
            this.sizeCells[this.nbAggregates + this.nbGroups] = agg.length;
            ++this.nbAggregates;
        }
        this.aggregates = Arrays.copyOfRange(this.aggregates, 0, this.nbAggregates);
        for (cc = 0; cc < this.nbGroups; ++cc) {
            int sizeCC;
            this.sizeCells[cc] = sizeCC = groupGraph.getSizeCC()[cc];
            int[] g = groupGraph.getCC(cc);
            for (int i = 0; i < sizeCC; ++i) {
                g[i] = this.getPartialIndex(g[i]);
            }
            this.groups[cc] = SetFactory.makeConstantSet(g);
        }
        this.sizeCells = Arrays.copyOfRange(this.sizeCells, 0, this.nbGroups + this.nbAggregates);
        for (cc = 0; cc < this.nbGroups; ++cc) {
            ISetIterator iSetIterator = this.groups[cc].iterator();
            while (iSetIterator.hasNext()) {
                int i = (Integer)iSetIterator.next();
                this.gridIdToGroupedId.put(i, cc);
            }
        }
    }

    private boolean isGrouped(int completeIndex) {
        return this.groupedCells.contains(completeIndex);
    }

    private int[] getMaxAggregate(int idx) {
        int[] agg = new int[this.aggregationFactor * this.aggregationFactor];
        int i = 0;
        int nWidth = (int)Math.ceil(1.0 * (double)this.nbCols / (double)this.aggregationFactor);
        int offsetRow = Math.floorDiv(idx, nWidth) * this.aggregationFactor;
        int offsetCol = idx % nWidth * this.aggregationFactor;
        for (int row = 0; row < this.aggregationFactor; ++row) {
            for (int col = 0; col < this.aggregationFactor; ++col) {
                if (row + offsetRow >= this.getNbRows() || col + offsetCol >= this.getNbCols()) continue;
                int compIdx = this.getCompleteIndexFromCoordinates(row + offsetRow, col + offsetCol);
                if (this.getDiscardSet().contains(compIdx)) continue;
                agg[i] = this.getPartialIndex(compIdx);
                ++i;
            }
        }
        return Arrays.copyOfRange(agg, 0, i);
    }

    @Override
    public int getNbCells() {
        return this.nbGroups + this.nbAggregates;
    }

    @Override
    public int getNbUngroupedCells() {
        return super.getNbCells();
    }

    public ISet getGroup(int groupId) {
        return this.groups[groupId];
    }

    @Override
    public int[] getSizeCells() {
        return this.sizeCells;
    }

    public int getNbAggregates() {
        return this.nbAggregates;
    }

    @Override
    public int getNbGroups() {
        return this.nbGroups;
    }

    public int[] getAggregatePartialIndices(int aggregateIdx) {
        if (aggregateIdx < this.nbGroups) {
            throw new RuntimeException("Wrong aggregate index");
        }
        return this.aggregates[aggregateIdx - this.nbGroups].toArray();
    }

    public int[] getAggregateCompleteIndices(int aggregateIdx) {
        if (aggregateIdx < this.nbGroups) {
            throw new RuntimeException("Wrong aggregate index");
        }
        return IntStream.of(this.aggregates[aggregateIdx - this.nbGroups].toArray()).map(i -> this.getCompleteIndex(i)).toArray();
    }

    @Override
    public int[] getUngroupedCompleteIndices(int[] pus) {
        ISet indices = SetFactory.makeRangeSet();
        for (int pu : pus) {
            for (int i : this.getAggregateCompleteIndices(pu)) {
                indices.add(i);
            }
        }
        return indices.toArray();
    }

    public int getGroupIndexFromCompleteIndex(int completeIndex) {
        int partialIndex = this.getPartialIndex(completeIndex);
        return this.gridIdToGroupedId.get(partialIndex);
    }

    @Override
    public int getGroupIndexFromPartialIndex(int partialIndex) {
        if (!this.gridIdToGroupedId.containsKey(partialIndex)) {
            System.out.println(partialIndex);
            System.out.println(this.groupedCells.contains(this.getCompleteIndex(partialIndex)));
        }
        return this.gridIdToGroupedId.get(partialIndex);
    }

    @Override
    public double[][] getCartesianCoordinates() {
        double[][] coords = new double[super.getNbCells()][];
        for (int i = 0; i < super.getNbCells(); ++i) {
            int[] coord = super.getCoordinatesFromIndex(i);
            coords[i] = new double[]{coord[1], coord[0]};
        }
        return coords;
    }

    @Override
    public double[] getCartesianCoordinates(int aggregateIdx) throws RestoptException {
        if (aggregateIdx < this.getNbGroups()) {
            throw new RestoptException("Cannot associate cartesian coordinates to a grouped cell");
        }
        int[] agg = this.aggregates[aggregateIdx - this.nbGroups].toArray();
        double[] coords = new double[]{0.0, 0.0};
        for (int i = 0; i < agg.length; ++i) {
            double[] c = this.getCartesianCoordinatesFromPartialIndex(agg[i]);
            coords[0] = coords[0] + c[0];
            coords[1] = coords[1] + c[1];
        }
        coords[0] = coords[0] / (double)agg.length;
        coords[1] = coords[1] / (double)agg.length;
        return coords;
    }

    public double[] getCartesianCoordinatesFromPartialIndex(int partialIndex) {
        int[] c = super.getCoordinatesFromIndex(partialIndex);
        return new double[]{c[1], c[0]};
    }
}

