/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.trailing.trail.chunck;

import org.chocosolver.memory.trailing.StoredDouble;
import org.chocosolver.memory.trailing.trail.IStoredDoubleTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedTrail;
import org.chocosolver.memory.trailing.trail.chunck.DoubleWorld;

public class ChunckedDoubleTrail
extends ChunckedTrail<DoubleWorld>
implements IStoredDoubleTrail {
    private final int ws;
    private final double loadfactor;

    public ChunckedDoubleTrail(int ws, int nbWorlds, double loadfactor) {
        this.worlds = new DoubleWorld[nbWorlds];
        this.ws = ws;
        this.loadfactor = loadfactor;
        this.current = new DoubleWorld(ws, loadfactor);
        ((DoubleWorld[])this.worlds)[0] = this.current;
    }

    @Override
    public void worldPush(int worldIndex) {
        if (((DoubleWorld[])this.worlds)[worldIndex] == null) {
            this.current = new DoubleWorld(this.ws, this.loadfactor);
            ((DoubleWorld[])this.worlds)[worldIndex] = (DoubleWorld)this.current;
        } else {
            this.current = ((DoubleWorld[])this.worlds)[worldIndex];
            ((DoubleWorld)this.current).clear();
        }
        if (worldIndex == ((DoubleWorld[])this.worlds).length - 1) {
            this.resizeWorlds();
        }
    }

    private void resizeWorlds() {
        int newCapacity = (int)((double)((DoubleWorld[])this.worlds).length * this.loadfactor);
        DoubleWorld[] tmp = new DoubleWorld[newCapacity];
        System.arraycopy(this.worlds, 0, tmp, 0, ((DoubleWorld[])this.worlds).length);
        this.worlds = tmp;
    }

    @Override
    public void savePreviousState(StoredDouble v, double oldValue, int oldStamp) {
        ((DoubleWorld)this.current).savePreviousState(v, oldValue, oldStamp);
    }
}

