/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import gnu.trove.list.array.TIntArrayList;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IGraphDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.PairProcedure;

public class PropTransitivity<V extends GraphVar<?>>
extends Propagator<V> {
    private final V g;
    private final IGraphDeltaMonitor gdm;
    private final PairProcedure arcEnforced;
    private final PairProcedure arcRemoved;
    private final TIntArrayList eF;
    private final TIntArrayList eT;
    private final TIntArrayList rF;
    private final TIntArrayList rT;

    public PropTransitivity(V graph) {
        super((Variable[])new GraphVar[]{graph}, (Priority)PropagatorPriority.LINEAR, true);
        this.g = graph;
        this.gdm = this.g.monitorDelta(this);
        int n = this.g.getNbMaxNodes();
        this.eF = new TIntArrayList(n);
        this.eT = new TIntArrayList(n);
        this.rF = new TIntArrayList(n);
        this.rT = new TIntArrayList(n);
        this.arcEnforced = this::arcEnforced;
        this.arcRemoved = this::arcRemoved;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int n = this.g.getNbMaxNodes();
        ISetIterator iSetIterator = this.g.getPotentialNodes().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            for (int j = 0; j < n; ++j) {
                if (this.g.getMandatorySuccessorsOf(i).contains(j)) {
                    this.arcEnforced(i, j);
                    continue;
                }
                if (this.g.getPotentialSuccessorsOf(i).contains(j)) continue;
                this.arcRemoved(i, j);
            }
        }
        this.filter();
        this.gdm.startMonitoring();
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.rT.clear();
        this.rF.clear();
        this.eT.clear();
        this.eF.clear();
        this.gdm.forEachEdge(this.arcEnforced, GraphEventType.ADD_EDGE);
        this.gdm.forEachEdge(this.arcRemoved, GraphEventType.REMOVE_EDGE);
        this.filter();
    }

    private void filter() throws ContradictionException {
        assert (this.eF.size() == this.eT.size());
        while (!this.eF.isEmpty()) {
            assert (this.eF.size() == this.eT.size());
            this.enfArc(this.eF.removeAt(this.eF.size() - 1), this.eT.removeAt(this.eT.size() - 1));
        }
        assert (this.rF.size() == this.rT.size());
        while (!this.rF.isEmpty()) {
            assert (this.rF.size() == this.rT.size());
            this.remArc(this.rF.removeAt(this.rF.size() - 1), this.rT.removeAt(this.rT.size() - 1));
        }
        assert (this.eF.size() == this.eT.size());
        if (!this.eF.isEmpty()) {
            this.filter();
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return GraphEventType.REMOVE_EDGE.getMask() + GraphEventType.ADD_EDGE.getMask();
    }

    @Override
    public ESat isEntailed() {
        int n = this.g.getNbMaxNodes();
        for (int i = 0; i < n; ++i) {
            ISetIterator iSetIterator = this.g.getMandatorySuccessorsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (i == j) continue;
                ISetIterator iSetIterator2 = this.g.getMandatorySuccessorsOf(j).iterator();
                while (iSetIterator2.hasNext()) {
                    int j2 = (Integer)iSetIterator2.next();
                    if (j2 == i || this.g.getPotentialSuccessorsOf(i).contains(j2)) continue;
                    return ESat.FALSE;
                }
            }
        }
        if (this.g.isInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    private void arcEnforced(int x, int y) {
        this.eF.add(x);
        this.eT.add(y);
    }

    private void arcRemoved(int x, int y) {
        this.rF.add(x);
        this.rT.add(y);
    }

    private void enfArc(int from, int to) throws ContradictionException {
        if (from != to) {
            int i;
            ISet ker = this.g.getMandatorySuccessorsOf(to);
            ISet env = this.g.getPotentialSuccessorsOf(to);
            ISetIterator iSetIterator = env.iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (i == to || i == from) continue;
                if (ker.contains(i)) {
                    if (!this.g.enforceEdge(from, i, this)) continue;
                    this.arcEnforced(from, i);
                    continue;
                }
                if (this.g.getPotentialSuccessorsOf(from).contains(i) || !this.g.removeEdge(to, i, this)) continue;
                this.arcRemoved(to, i);
            }
            ker = this.g.getMandatoryPredecessorsOf(from);
            env = this.g.getPotentialPredecessorOf(from);
            iSetIterator = env.iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (i == to || i == from) continue;
                if (ker.contains(i)) {
                    if (!this.g.enforceEdge(i, to, this)) continue;
                    this.arcEnforced(i, to);
                    continue;
                }
                if (this.g.getPotentialSuccessorsOf(i).contains(to) || !this.g.removeEdge(i, from, this)) continue;
                this.arcRemoved(i, from);
            }
        }
    }

    private void remArc(int from, int to) throws ContradictionException {
        if (from != to) {
            int i;
            ISetIterator iSetIterator = this.g.getMandatorySuccessorsOf(from).iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (!this.g.removeEdge(i, to, this)) continue;
                this.arcRemoved(i, to);
            }
            iSetIterator = this.g.getMandatoryPredecessorsOf(to).iterator();
            while (iSetIterator.hasNext()) {
                i = (Integer)iSetIterator.next();
                if (!this.g.removeEdge(from, i, this)) continue;
                this.arcRemoved(from, i);
            }
        }
    }
}

