% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_dsd.R
\name{extract_dsd}
\alias{extract_dsd}
\title{Extract the Data Structure Definition content from SDMX XML}
\usage{
extract_dsd(concept = NULL, dsd_xml = NULL)
}
\arguments{
\item{concept}{a character vector with a concept id}

\item{dsd_xml}{an XML file with DSD content}
}
\value{
a matrix with 3 columns if the provided \code{concept} has a code list in the DSD file. The first column is the provided \code{concept}. The second column 
        is the possible codes under the given \code{concept}. The last column is the name/description for the code in the second column, which can be used as labels.
}
\description{
Extracts values from the XML Data Structure Definition (DSD) file
}
\details{
It is a sub-function to use in the \code{\link{get_eurostat_dsd}} function.
}
\examples{
\dontshow{
if (parallel::detectCores()<=2){
   options(restatapi_cores=1)
}else{
   options(restatapi_cores=2)
}    
}
\donttest{
dsd_url<-"https://ec.europa.eu/eurostat/SDMX/diss-web/rest/datastructure/ESTAT/DSD_med_rd6"
options(timeout=2)
tryCatch({
  dsd_xml<-xml2::read_xml(dsd_url)}, 
  error=function(e){
  message("Unable to download the xml file.\n",e)}, 
  warning=function(w){
  message("Unable to download the xml file.\n",w)}) 
if (exists("dsd_xml")) {extract_dsd("GEO",dsd_xml)} 
options(timeout=2)
}
}
