% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_DO.R
\name{convert_DO}
\alias{convert_DO}
\title{Convert between units of dissolved oxygen}
\usage{
convert_DO(
  x,
  from = NULL,
  to = NULL,
  S = NULL,
  t = NULL,
  P = NULL,
  simplify = TRUE
)
}
\arguments{
\item{x}{numeric. The dissolved oxygen (DO) value(s) to be converted.}

\item{from}{string. The DO unit to convert \emph{from}. See \code{\link[=unit_args]{unit_args()}} for
details.}

\item{to}{string. The DO unit to convert \emph{to}. See \code{\link[=unit_args]{unit_args()}} for details.}

\item{S}{numeric. Salinity (ppt). Defaults to NULL. Required for conversion
of some units. See \code{\link[=unit_args]{unit_args()}} for details.}

\item{t}{numeric. Temperature(°C). Defaults to NULL. Required for conversion
of some units. See \code{\link[=unit_args]{unit_args()}} for details.}

\item{P}{numeric. Pressure (bar). Defaults to 1.013253. Required for
conversion of some units. See \code{\link[=unit_args]{unit_args()}} for details.}

\item{simplify}{logical. Defaults to \code{TRUE} in which case the converted
values are returned as a numeric vector. if \code{FALSE} a list object of class
\code{convert_DO} is returned.}
}
\value{
By default (\code{simplify = TRUE}) the output is a numeric vector of
converted values. If \code{simplify = FALSE} output is a \code{list} object of class
\code{convert_DO} containing five elements: \verb{$call} the function call, \verb{$input}
values, \verb{$output} converted values, \verb{$input.unit} and \verb{$output.unit}.
\subsection{More}{

For additional help, documentation, vignettes, and more visit the \code{respR}
website at \url{https://januarharianto.github.io/respR/}
}
}
\description{
This is a conversion function that performs conversions between concentration
and pressure units of dissolved oxygen (DO).
}
\details{
The function uses an internal database and a fuzzy string matching algorithm
to accept various unit formatting styles. For example, \code{"mg/l"}, \code{"mg/L"},
\code{"mgL-1"}, \code{"mg l-1"}, \code{"mg.l-1"} are all parsed the same. See
\verb{[unit_args()]} for details of accepted units.

Oxygen concentration units should use SI units (\code{L} or \code{kg}) for the
denominator.

Some DO units require temperature (\code{t}), salinity (\code{S}), and atmospheric
pressure (\code{P}) to be specified; if this is the case the function will stop
and prompt for them. For the atmospheric pressure input (P), a default value
of 1.013 bar (standard pressure at sea level) is applied if not otherwise
entered. For freshwater experiments, salinity should be set to zero (i.e. \code{S = 0}).
\subsection{S3 Generic Functions}{

Saved output objects (if \code{simplify = FALSE} is used) can be entered in the
generic S3 functions \code{print()} and \code{summary()}.
\itemize{
\item \code{print()}: prints input and converted values (up to first 20), plus input
and output units.
\item \code{summary()}: simple wrapper for \code{print()} function. See above.
}
}
}
\examples{
# Convert a numeric value from & to units which do not require t, S and P
convert_DO(8.21, from = "mg/L", to = "umol/L")

# Convert a numeric value from & to units which require t, S and P
convert_DO(100, from = "\%Air", to = "mg L-1", S = 33, t = 18)
convert_DO(214, from = "hPa", to = "mL/kg", S = 33, t = 18)

# Convert a vector of values
convert_DO(urchins.rd[[5]], from = "mg/L", to = "umol/L")
convert_DO(c(8.01, 8.03, 8.05), from = "mg per litre", to = "\%Air",
  t = 15, S = 35)
convert_DO(sardine.rd[[2]], from = "\%Air", to = "torr",
  t = 15, S = 35)
}
