% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_data_download.R
\name{get_2d_spectrum}
\alias{get_2d_spectrum}
\title{Download the 2D spectrum data from IFREMER ftp}
\usage{
get_2d_spectrum(point, start = "1994-01-01", end = "1994-02-28")
}
\arguments{
\item{point}{the location name (string) requested.
Alternatively, the node number. The consistency is checked internally.}

\item{start}{the starting date (as a string). The consistency is checked internally.}

\item{end}{the ending date as a string}
}
\value{
A list with 9 elements:
\describe{
\item{longitude}{Longitude}
\item{latitude}{Latitude}
\item{frequency1}{Lower frequency}
\item{frequency2}{Upper frequency}
\item{ef}{Surface elevation variance spectral density}
\item{th1m}{Mean direction from first spectral moment}
\item{th2m}{Mean direction from second spectral moment}
\item{sth1m}{Mean directional spreading from first spectral moment}
\item{sth2m}{Mean directional spreading from second spectral moment}
\item{freq}{Central frequency}
\item{dir}{Directionnal bins}
\item{forcings}{A data.frame with 6 variables:
\describe{
\item{time}{Time}
\item{dpt}{Depth, positive downward}
\item{wnd}{Wind intensity, at 10m above sea level}
\item{wnddir}{Wind direction, comes from}
\item{cur}{Current intensity, at the surface}
\item{curdir}{Current direction, going to}
}}
\item{station}{Station name}
}
}
\description{
Download the 2D spectrum data from IFREMER ftp
}
\examples{
\dontshow{if (curl::has_internet()) withAutoprint(\{ # examplesIf}
spec2D <- get_2d_spectrum("SEMREVO", start = "1994-01-01", end = "1994-02-28")
image(spec2D$dir, spec2D$freq, spec2D$efth[, , 1],
  xlab = "Direction (°)",
  ylab = "Frequency (Hz"
)
\dontshow{\}) # examplesIf}
}
