% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxtracto.R
\name{rxtracto}
\alias{rxtracto}
\title{Extract environmental data along a trajectory from an 'ERDDAP' server using 'rerddap'.}
\usage{
rxtracto(
  dataInfo,
  parameter = NULL,
  xcoord = NULL,
  ycoord = NULL,
  zcoord = NULL,
  tcoord = NULL,
  xlen = 0,
  ylen = 0,
  zlen = 0,
  xName = "longitude",
  yName = "latitude",
  zName = "altitude",
  tName = "time",
  verbose = FALSE
)
}
\arguments{
\item{dataInfo}{- the return from an 'rerddap::info' call to an 'ERDDAP' server}

\item{parameter}{- character string containing the name of the parameter to extract}

\item{xcoord}{- a real array with the x-coordinates of the trajectory (if longitude in #'   decimal degrees East, either 0-360 or -180 to 180)}

\item{ycoord}{-  a real array with the y-coordinate of the trajectory (if latitude in
decimal degrees N; -90 to 90)}

\item{zcoord}{-a real array with the z-coordinate of the trajectory (usually altitude or depth)}

\item{tcoord}{- a character array with the times of the trajectory in
"YYYY-MM-DD" - for now restricted to be time.}

\item{xlen}{- real array defining the longitude box around the given point (xlen/2 around the point)}

\item{ylen}{- real array defining the latitude box around the given point (ylen/2 around the point)}

\item{zlen}{- real array defining the depth or altitude box around the given point (zlen/2 around the point)}

\item{xName}{- character string with name of the xcoord in the 'ERDDAP' dataset (default "longitude")}

\item{yName}{- character string with name of the ycoord in the 'ERDDAP' dataset (default "latitude")}

\item{zName}{- character string with name of the zcoord in the 'ERDDAP' dataset (default "altitude")}

\item{tName}{- character string with name of the tcoord in the 'ERDDAP' dataset (default "time")}

\item{verbose}{- logical variable (default FALSE)
if the the URL request should be verbose}
}
\value{
A dataframe containing:
\itemize{
 \item column 1 = mean of data within search radius
 \item column 2 = standard deviation of data within search radius
 \item column 3 = number of points found within search radius
 \item column 4 = time of returned value
 \item column 5 = min longitude of call (decimal degrees)
 \item column 6 = max longitude of call (decimal degrees)
 \item column 7 = min latitude of call (decimal degrees)
 \item column 8 = max latitude of call (decimal degrees)
 \item column 9 = requested time in tag
 \item column 10 = median of data within search radius
 \item column 11 = median absolute deviation of data within search radius
 }
}
\description{
\code{rxtracto} uses the R program 'rerddap' to extract environmental
data from an 'ERDDAP' server along a (x,y,z, time) trajectory.
}
\examples{
# toy example to show use
# but keep execution time down
\donttest{
dataInfo <- rerddap::info('erdHadISST')
}
parameter <- 'sst'
xcoord <- c(-130.5)
ycoord <- c(40.5)
tcoord <- c('2006-01-16')
xlen <- 0.01
ylen <- 0.01
extract <- rxtracto(dataInfo, parameter = parameter, xcoord = xcoord,
                    ycoord = ycoord, tcoord= tcoord,
                    xlen = xlen, ylen = ylen)
\donttest{
# 2-D example getting bathymetry
dataInfo <- rerddap::info('etopo360')
parameter <- 'altitude'
extract <- rxtracto(dataInfo, parameter, xcoord = xcoord, ycoord = ycoord,
                    xlen = xlen, ylen = ylen)
}

}
