% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swapi.R
\docType{data}
\name{sw_people}
\alias{sw_people}
\alias{sw_films}
\alias{sw_planets}
\alias{sw_species}
\alias{sw_vehicles}
\alias{sw_starships}
\title{Entities from the Star Wars Universe}
\format{Unnamed lists with varying number of components.}
\source{
Data comes from \url{http://swapi.co/} retrieved using
   the \code{rwars} package: \url{https://github.com/Ironholds/rwars}
}
\usage{
sw_people

sw_films

sw_planets

sw_species

sw_vehicles

sw_starships
}
\description{
Data retrieved from the swapi API on the Star Wars Universe.
}
\details{
\itemize{
  \item \code{sw_people} List of individual people or characters within the Star Wars universe.
  \item \code{sw_starships} List of transport crafts with hyperdrive capability.
  \item \code{sw_vehicles} List of transport crafts without hyperdrive capability.
  \item \code{sw_films} List of Star Wars films.
  \item \code{sw_species} List of types of people or characters within the Star Wars Universe.
  \item \code{sw_planets} List of large masses, planets or planetoids in the Star Wars Universe, at the time of 0 ABY.
}
}
\examples{
# sw_people
length(sw_people)
names(sw_people[[1]])
sapply(sw_people, `[[`, "name")

# sw_films
length(sw_films)
names(sw_films[[1]])
sapply(sw_films, `[[`, "title")
}
\keyword{datasets}
