% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache-helpers.R
\name{.prepareFileBackedRaster}
\alias{.prepareFileBackedRaster}
\title{Copy the file-backing of a file-backed Raster* object}
\usage{
.prepareFileBackedRaster(
  obj,
  repoDir = NULL,
  overwrite = FALSE,
  drv = getOption("reproducible.drv", RSQLite::SQLite()),
  conn = getOption("reproducible.conn", NULL),
  ...
)
}
\arguments{
\item{obj}{The raster object to save to the repository.}

\item{repoDir}{Character denoting an existing directory in which an artifact will be saved.}

\item{overwrite}{Logical. Should the raster be saved to disk, overwriting existing file.}

\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{conn}{A \linkS4class{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{...}{Not used}
}
\value{
A raster object and its newly located file backing.
Note that if this is a legitimate Cache repository, the new location
will be a subdirectory called \file{rasters/} of \file{repoDir/}.
If this is not a repository, the new location will be within \code{repoDir}.
}
\description{
Rasters are sometimes file-based, so the normal save and copy and assign
mechanisms in R don't work for saving, copying and assigning.
This function creates an explicit file copy of the file that is backing the raster,
and changes the pointer (i.e., \code{filename(object)}) so that it is pointing
to the new file.
}
\author{
Eliot McIntire
}
